/*
 * Decompiled with CFR 0.152.
 */
package smile.manifold;

import java.io.Serializable;
import java.util.Arrays;
import java.util.function.Function;
import smile.math.MathEx;
import smile.math.blas.UPLO;
import smile.math.kernel.MercerKernel;
import smile.math.matrix.ARPACK;
import smile.math.matrix.IMatrix;
import smile.math.matrix.Matrix;

public class KPCA<T>
implements Function<T, double[]>,
Serializable {
    private static final long serialVersionUID = 2L;
    private final T[] data;
    private final MercerKernel<T> kernel;
    private final double[] mean;
    private final double mu;
    private final double[] latent;
    private final Matrix projection;
    private final double[][] coordinates;

    public KPCA(T[] data, MercerKernel<T> kernel, double[] mean, double mu, double[][] coordinates, double[] latent, Matrix projection) {
        this.data = data;
        this.kernel = kernel;
        this.mean = mean;
        this.mu = mu;
        this.coordinates = coordinates;
        this.latent = latent;
        this.projection = projection;
    }

    public static <T> KPCA<T> fit(T[] data, MercerKernel<T> kernel, int k) {
        return KPCA.fit(data, kernel, k, 1.0E-4);
    }

    public static <T> KPCA<T> fit(T[] data, MercerKernel<T> kernel, int k, double threshold) {
        if (threshold < 0.0) {
            throw new IllegalArgumentException("Invalid threshold = " + threshold);
        }
        if (k < 1 || k > data.length) {
            throw new IllegalArgumentException("Invalid dimension of feature space: " + k);
        }
        int n = data.length;
        Matrix K = new Matrix(n, n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= i; ++j) {
                double x = kernel.k(data[i], data[j]);
                K.set(i, j, x);
                K.set(j, i, x);
            }
        }
        double[] mean = K.rowMeans();
        double mu = MathEx.mean((double[])mean);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= i; ++j) {
                double x = K.get(i, j) - mean[i] - mean[j] + mu;
                K.set(i, j, x);
                K.set(j, i, x);
            }
        }
        K.uplo(UPLO.LOWER);
        Matrix.EVD eigen = ARPACK.syev((IMatrix)K, (ARPACK.SymmOption)ARPACK.SymmOption.LA, (int)k);
        double[] eigvalues = eigen.wr;
        Matrix eigvectors = eigen.Vr;
        int p = (int)Arrays.stream(eigvalues).limit(k).filter(e -> e / (double)n > threshold).count();
        double[] latent = new double[p];
        Matrix projection = new Matrix(p, n);
        for (int j = 0; j < p; ++j) {
            latent[j] = eigvalues[j];
            double s = Math.sqrt(latent[j]);
            for (int i = 0; i < n; ++i) {
                projection.set(j, i, eigvectors.get(i, j) / s);
            }
        }
        Matrix coord = projection.mm(K);
        double[][] coordinates = new double[n][p];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < p; ++j) {
                coordinates[i][j] = coord.get(j, i);
            }
        }
        return new KPCA<T>(data, kernel, mean, mu, coordinates, latent, projection);
    }

    public double[] variances() {
        return this.latent;
    }

    public Matrix projection() {
        return this.projection;
    }

    public double[][] coordinates() {
        return this.coordinates;
    }

    @Override
    public double[] apply(T x) {
        int n = this.data.length;
        double[] y = new double[n];
        for (int i = 0; i < n; ++i) {
            y[i] = this.kernel.k(x, this.data[i]);
        }
        double my = MathEx.mean((double[])y);
        for (int i = 0; i < n; ++i) {
            y[i] = y[i] - my - this.mean[i] + this.mu;
        }
        return this.projection.mv(y);
    }

    @Override
    public double[][] apply(T[] x) {
        int m = x.length;
        double[][] y = new double[m][];
        for (int i = 0; i < m; ++i) {
            y[i] = this.apply(x[i]);
        }
        return y;
    }
}

