/*
 * Decompiled with CFR 0.152.
 */
package smile.manifold;

import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.manifold.MDS;
import smile.math.BFGS;
import smile.math.DifferentiableMultivariateFunction;
import smile.math.MathEx;
import smile.sort.QuickSort;

public class IsotonicMDS {
    private static final Logger logger = LoggerFactory.getLogger(IsotonicMDS.class);
    public final double stress;
    public final double[][] coordinates;

    public IsotonicMDS(double stress, double[][] coordinates) {
        this.stress = stress;
        this.coordinates = coordinates;
    }

    public static IsotonicMDS of(double[][] proximity) {
        return IsotonicMDS.of(proximity, new Properties());
    }

    public static IsotonicMDS of(double[][] proximity, int k) {
        return IsotonicMDS.of(proximity, k, 1.0E-4, 200);
    }

    public static IsotonicMDS of(double[][] proximity, Properties params) {
        int k = Integer.parseInt(params.getProperty("smile.isotonic_mds.k", "2"));
        double tol = Double.parseDouble(params.getProperty("smile.isotonic_mds.tolerance", "1E-4"));
        int maxIter = Integer.parseInt(params.getProperty("smile.isotonic_mds.iterations", "200"));
        return IsotonicMDS.of(proximity, k, tol, maxIter);
    }

    public static IsotonicMDS of(double[][] proximity, int k, double tol, int maxIter) {
        return IsotonicMDS.of(proximity, MDS.of((double[][])proximity, (int)k).coordinates, tol, maxIter);
    }

    public static IsotonicMDS of(double[][] proximity, double[][] init, double tol, int maxIter) {
        double stress;
        if (proximity.length != proximity[0].length) {
            throw new IllegalArgumentException("The proximity matrix is not square.");
        }
        if (proximity.length != init.length) {
            throw new IllegalArgumentException("The proximity matrix and the initial coordinates are of different size.");
        }
        int nr = proximity.length;
        int nc = init[0].length;
        int n = nr * (nr - 1) / 2;
        double[] d = new double[n];
        int l = 0;
        for (int i = 0; i < nr; ++i) {
            int j = i + 1;
            while (j < nr) {
                d[l] = proximity[j][i];
                ++j;
                ++l;
            }
        }
        double[] x = new double[nr * nc];
        int l2 = 0;
        for (int i = 0; i < nr; ++i) {
            int j = 0;
            while (j < nc) {
                x[l2] = init[i][j];
                ++j;
                ++l2;
            }
        }
        int[] ord = QuickSort.sort((double[])d);
        int[] ord2 = QuickSort.sort((int[])((int[])ord.clone()));
        ObjectiveFunction func = new ObjectiveFunction(nr, nc, d, ord, ord2);
        try {
            stress = BFGS.minimize((DifferentiableMultivariateFunction)func, (int)5, (double[])x, (double)tol, (int)maxIter);
        }
        catch (Exception ex) {
            stress = BFGS.minimize((DifferentiableMultivariateFunction)func, (double[])x, (double)tol, (int)maxIter);
        }
        if (stress == 0.0) {
            logger.info(String.format("Isotonic MDS: error = %.1f%%. The fit is perfect.", 100.0 * stress));
        } else if (stress <= 0.025) {
            logger.info(String.format("Isotonic MDS: error = %.1f%%. The fit is excellent.", 100.0 * stress));
        } else if (stress <= 0.05) {
            logger.info(String.format("Isotonic MDS: error = %.1f%%. The fit is good.", 100.0 * stress));
        } else if (stress <= 0.1) {
            logger.info(String.format("Isotonic MDS: error = %.1f%%. The fit is fair.", 100.0 * stress));
        } else {
            logger.info(String.format("Isotonic MDS: error = %.1f%%. The fit may be poor.", 100.0 * stress));
        }
        double[][] coordinates = new double[nr][nc];
        int l3 = 0;
        for (int i = 0; i < nr; ++i) {
            int j = 0;
            while (j < nc) {
                coordinates[i][j] = x[l3];
                ++j;
                ++l3;
            }
        }
        return new IsotonicMDS(stress, coordinates);
    }

    static class ObjectiveFunction
    implements DifferentiableMultivariateFunction {
        int[] ord;
        int[] ord2;
        int n;
        int nr;
        int nc;
        double[] d;
        double[] y;
        double[] yc;
        double[] yf;

        ObjectiveFunction(int nr, int nc, double[] d, int[] ord, int[] ord2) {
            this.d = d;
            this.ord = ord;
            this.ord2 = ord2;
            this.nr = nr;
            this.nc = nc;
            this.n = d.length;
            this.y = new double[this.n];
            this.yf = new double[this.n];
            this.yc = new double[this.n + 1];
        }

        void dist(double[] x) {
            int index = 0;
            for (int i = 0; i < this.nr; ++i) {
                for (int j = i + 1; j < this.nr; ++j) {
                    double tmp = 0.0;
                    for (int c = 0; c < this.nc; ++c) {
                        tmp += MathEx.pow2((double)(x[i * this.nc + c] - x[j * this.nc + c]));
                    }
                    this.d[index++] = Math.sqrt(tmp);
                }
            }
            for (index = 0; index < this.n; ++index) {
                this.y[index] = this.d[this.ord[index]];
            }
        }

        public double f(double[] x) {
            this.dist(x);
            this.yc[0] = 0.0;
            double tmp = 0.0;
            for (int i = 0; i < this.n; ++i) {
                this.yc[i + 1] = tmp += this.y[i];
            }
            int ip = 0;
            int known = 0;
            do {
                int i;
                double slope = 1.0E200;
                for (i = known + 1; i <= this.n; ++i) {
                    tmp = (this.yc[i] - this.yc[known]) / (double)(i - known);
                    if (!(tmp < slope)) continue;
                    slope = tmp;
                    ip = i;
                }
                for (i = known; i < ip; ++i) {
                    this.yf[i] = (this.yc[ip] - this.yc[known]) / (double)(ip - known);
                }
            } while ((known = ip) < this.n);
            double sstar = 0.0;
            double tstar = 0.0;
            for (int i = 0; i < this.n; ++i) {
                tmp = this.y[i] - this.yf[i];
                sstar += tmp * tmp;
                tstar += this.y[i] * this.y[i];
            }
            return Math.sqrt(sstar / tstar);
        }

        public double g(double[] x, double[] g) {
            this.dist(x);
            this.yc[0] = 0.0;
            double tmp = 0.0;
            for (int i = 0; i < this.n; ++i) {
                this.yc[i + 1] = tmp += this.y[i];
            }
            int ip = 0;
            int known = 0;
            do {
                int i;
                double slope = 1.0E200;
                for (i = known + 1; i <= this.n; ++i) {
                    tmp = (this.yc[i] - this.yc[known]) / (double)(i - known);
                    if (!(tmp < slope)) continue;
                    slope = tmp;
                    ip = i;
                }
                for (i = known; i < ip; ++i) {
                    this.yf[i] = (this.yc[ip] - this.yc[known]) / (double)(ip - known);
                }
            } while ((known = ip) < this.n);
            double sstar = 0.0;
            double tstar = 0.0;
            for (int i = 0; i < this.n; ++i) {
                tmp = this.y[i] - this.yf[i];
                sstar += tmp * tmp;
                tstar += this.y[i] * this.y[i];
            }
            double ssq = Math.sqrt(sstar / tstar);
            for (int u = 0; u < this.nr; ++u) {
                for (int i = 0; i < this.nc; ++i) {
                    tmp = 0.0;
                    for (int s = 0; s < this.nr; ++s) {
                        if (s == u) continue;
                        int k = s > u ? this.nr * u - u * (u + 1) / 2 + s - u : this.nr * s - s * (s + 1) / 2 + u - s;
                        if ((k = this.ord2[k - 1]) >= this.n) continue;
                        double tmp1 = x[u * this.nc + i] - x[s * this.nc + i];
                        double sgn = tmp1 >= 0.0 ? 1.0 : -1.0;
                        tmp1 = Math.abs(tmp1) / this.y[k];
                        tmp += ((this.y[k] - this.yf[k]) / sstar - this.y[k] / tstar) * sgn * tmp1;
                    }
                    g[u * this.nc + i] = tmp * ssq;
                }
            }
            return ssq;
        }
    }
}

