/*
 * Decompiled with CFR 0.152.
 */
package smile.hpo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;
import smile.math.MathEx;

public class Hyperparameters {
    private final HashMap<String, Object> parameters = new HashMap();

    public Hyperparameters add(String name, int value) {
        return this.add(name, new int[]{value});
    }

    public Hyperparameters add(String name, double value) {
        return this.add(name, new double[]{value});
    }

    public Hyperparameters add(String name, String value) {
        return this.add(name, new String[]{value});
    }

    public Hyperparameters add(String name, int[] values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("Empty array");
        }
        this.parameters.put(name, values);
        return this;
    }

    public Hyperparameters add(String name, double[] values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("Empty array");
        }
        this.parameters.put(name, values);
        return this;
    }

    public Hyperparameters add(String name, String[] values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("Empty array");
        }
        this.parameters.put(name, values);
        return this;
    }

    public Hyperparameters add(String name, int start, int end) {
        this.parameters.put(name, new IntRange(start, end));
        return this;
    }

    public Hyperparameters add(String name, int start, int end, int step) {
        this.parameters.put(name, new IntRange(start, end, step));
        return this;
    }

    public Hyperparameters add(String name, double start, double end) {
        this.parameters.put(name, new DoubleRange(start, end));
        return this;
    }

    public Hyperparameters add(String name, double start, double end, double step) {
        this.parameters.put(name, new DoubleRange(start, end, step));
        return this;
    }

    public Stream<Properties> random() {
        return Stream.generate(() -> {
            Properties params = new Properties();
            this.parameters.forEach((name, values) -> {
                if (values instanceof int[]) {
                    int[] a = (int[])values;
                    int v = a.length == 1 ? a[0] : a[MathEx.randomInt((int)a.length)];
                    params.setProperty((String)name, String.valueOf(v));
                } else if (values instanceof double[]) {
                    double[] a = (double[])values;
                    double v = a.length == 1 ? a[0] : a[MathEx.randomInt((int)a.length)];
                    params.setProperty((String)name, String.valueOf(v));
                } else if (values instanceof String[]) {
                    String[] a = (String[])values;
                    String v = a.length == 1 ? a[0] : a[MathEx.randomInt((int)a.length)];
                    params.setProperty((String)name, v);
                } else if (values instanceof IntRange) {
                    IntRange range = (IntRange)values;
                    params.setProperty((String)name, String.valueOf(MathEx.randomInt((int)range.start, (int)range.end)));
                } else if (values instanceof DoubleRange) {
                    DoubleRange range = (DoubleRange)values;
                    params.setProperty((String)name, String.valueOf(MathEx.random((double)range.start, (double)range.end)));
                } else {
                    throw new IllegalStateException("Unknown parameter type: " + values);
                }
            });
            return params;
        });
    }

    public Stream<Properties> grid() {
        ArrayList<Map.Entry<String, Object>> lists = new ArrayList<Map.Entry<String, Object>>(this.parameters.entrySet());
        ArrayList combinations = new ArrayList();
        for (Pair pair : this.values(lists.get(0))) {
            ArrayList<Pair> newList = new ArrayList<Pair>();
            newList.add(pair);
            combinations.add(newList);
        }
        for (int i = 1; i < lists.size(); ++i) {
            ArrayList<Pair> nextList = this.values(lists.get(i));
            ArrayList newCombinations = new ArrayList();
            for (ArrayList arrayList : combinations) {
                for (Pair second : nextList) {
                    ArrayList<Pair> newList = new ArrayList<Pair>(arrayList);
                    newList.add(second);
                    newCombinations.add(newList);
                }
            }
            combinations = newCombinations;
        }
        return combinations.stream().map(list -> {
            Properties params = new Properties();
            list.forEach(p -> params.setProperty(p.name, p.value));
            return params;
        });
    }

    private ArrayList<Pair> values(Map.Entry<String, Object> parameter) {
        ArrayList<Pair> list = new ArrayList<Pair>();
        String name = parameter.getKey();
        Object values = parameter.getValue();
        if (values instanceof int[]) {
            for (int value : (int[])values) {
                list.add(new Pair(name, String.valueOf(value)));
            }
        } else if (values instanceof double[]) {
            for (double value : (double[])values) {
                list.add(new Pair(name, String.valueOf(value)));
            }
        } else if (values instanceof String[]) {
            for (String value : (String[])values) {
                list.add(new Pair(name, String.valueOf(value)));
            }
        } else if (values instanceof IntRange) {
            for (int value : ((IntRange)values).toArray()) {
                list.add(new Pair(name, String.valueOf(value)));
            }
        } else if (values instanceof DoubleRange) {
            for (double value : ((DoubleRange)values).toArray()) {
                list.add(new Pair(name, String.valueOf(value)));
            }
        } else {
            throw new IllegalStateException("Unknown parameter type: " + values);
        }
        return list;
    }

    static class IntRange {
        int start;
        int end;
        int step;

        IntRange(int start, int end) {
            this(start, end, Math.max(1, (end - start) / 10));
        }

        IntRange(int start, int end, int step) {
            if (start >= end) {
                throw new IllegalArgumentException(String.format("start = %d, end = %d", start, end));
            }
            this.start = start;
            this.end = end;
            this.step = step;
        }

        int[] toArray() {
            int n = (this.end - this.start) / this.step + 1;
            int[] a = new int[n];
            a[0] = this.start;
            for (int i = 1; i < n; ++i) {
                a[i] = a[i - 1] + this.step;
            }
            return a;
        }
    }

    static class DoubleRange {
        double start;
        double end;
        double step;

        DoubleRange(double start, double end) {
            this(start, end, (end - start) / 10.0);
        }

        DoubleRange(double start, double end, double step) {
            if (start >= end) {
                throw new IllegalArgumentException(String.format("start = %f, end = %f", start, end));
            }
            this.start = start;
            this.end = end;
            this.step = step;
        }

        double[] toArray() {
            double intervals = (this.end - this.start) / this.step;
            int n = (int)Math.ceil(intervals);
            if (intervals == (double)n) {
                ++n;
            }
            double[] a = new double[n];
            a[0] = this.start;
            for (int i = 1; i < n; ++i) {
                a[i] = a[i - 1] + this.step;
            }
            return a;
        }
    }

    static class Pair {
        String name;
        String value;

        Pair(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

