/*
 * Decompiled with CFR 0.152.
 */
package smile.feature.transform;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import smile.data.AbstractTuple;
import smile.data.Tuple;
import smile.data.transform.Transform;
import smile.data.type.StructType;

public class Normalizer
implements Transform {
    private final Norm norm;
    private final Set<String> columns;

    public Normalizer(Norm norm, String ... columns) {
        if (columns.length == 0) {
            throw new IllegalArgumentException("Empty list of columns to transform");
        }
        this.norm = norm;
        this.columns = new HashSet<String>(Arrays.asList(columns));
    }

    public Tuple apply(final Tuple x) {
        final StructType schema = x.schema();
        double norm = 0.0;
        for (String column : this.columns) {
            double xi = x.getDouble(column);
            switch (this.norm.ordinal()) {
                case 0: {
                    norm += Math.abs(xi);
                    break;
                }
                case 1: {
                    norm += xi * xi;
                    break;
                }
                case 2: {
                    norm = Math.max(norm, Math.abs(xi));
                }
            }
        }
        if (this.norm == Norm.L2) {
            norm = Math.sqrt(norm);
        }
        final double scale = norm;
        return new AbstractTuple(){

            public Object get(int i) {
                if (Normalizer.this.columns.contains(schema.field((int)i).name)) {
                    return x.getDouble(i) / scale;
                }
                return x.get(i);
            }

            public StructType schema() {
                return schema;
            }
        };
    }

    public String toString() {
        return (Object)((Object)this.norm) + "_Normalizer(" + String.join((CharSequence)", ", this.columns) + ")";
    }

    public static enum Norm {
        L1,
        L2,
        L_INF;

    }
}

