/*
 * Decompiled with CFR 0.152.
 */
package smile.anomaly;

import smile.base.svm.KernelMachine;
import smile.base.svm.OCSVM;
import smile.math.kernel.MercerKernel;

public class SVM<T>
extends KernelMachine<T> {
    public SVM(MercerKernel<T> kernel, T[] vectors, double[] weight, double b) {
        super(kernel, vectors, weight, b);
    }

    public static <T> SVM<T> fit(T[] x, MercerKernel<T> kernel) {
        return SVM.fit(x, kernel, 0.5, 0.001);
    }

    public static <T> SVM<T> fit(T[] x, MercerKernel<T> kernel, double nu, double tol) {
        if (nu <= 0.0 || nu > 1.0) {
            throw new IllegalArgumentException("Invalid nu: " + nu);
        }
        if (tol <= 0.0) {
            throw new IllegalArgumentException("Invalid tol: " + tol);
        }
        OCSVM<T> svm = new OCSVM<T>(kernel, nu, tol);
        KernelMachine<T> model = svm.fit(x);
        return new SVM<T>(model.kernel(), model.vectors(), model.weights(), model.intercept());
    }
}

