/*
 * Decompiled with CFR 0.152.
 */
package smile.validation.metric;

import smile.math.MathEx;
import smile.validation.metric.RegressionMetric;

public class RMSE
implements RegressionMetric {
    private static final long serialVersionUID = 2L;
    public static final RMSE instance = new RMSE();

    @Override
    public double score(double[] truth, double[] prediction) {
        return RMSE.of(truth, prediction);
    }

    public static double of(double[] truth, double[] prediction) {
        if (truth.length != prediction.length) {
            throw new IllegalArgumentException(String.format("The vector sizes don't match: %d != %d.", truth.length, prediction.length));
        }
        int n = truth.length;
        double rss = 0.0;
        for (int i = 0; i < n; ++i) {
            rss += MathEx.sqr((double)(truth[i] - prediction[i]));
        }
        return Math.sqrt(rss / (double)n);
    }

    public String toString() {
        return "RMSE";
    }
}

