/*
 * Decompiled with CFR 0.152.
 */
package smile.validation;

import java.io.Serializable;

public class RegressionMetrics
implements Serializable {
    private static final long serialVersionUID = 2L;
    public final double fitTime;
    public final double scoreTime;
    public final int size;
    public final double rss;
    public final double mse;
    public final double rmse;
    public final double mad;
    public final double r2;

    public RegressionMetrics(double fitTime, double scoreTime, int size, double rss, double mse, double rmse, double mad, double r2) {
        this.fitTime = fitTime;
        this.scoreTime = scoreTime;
        this.size = size;
        this.rss = rss;
        this.mse = mse;
        this.rmse = rmse;
        this.mad = mad;
        this.r2 = r2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{\n");
        sb.append(String.format("  fit time: %.3f ms,\n", this.fitTime));
        sb.append(String.format("  score time: %.3f ms,\n", this.scoreTime));
        sb.append(String.format("  validation data size:: %d,\n", this.size));
        sb.append(String.format("  RSS: %.4f,\n", this.rss));
        sb.append(String.format("  MSE: %.4f,\n", this.mse));
        sb.append(String.format("  RMSE: %.4f,\n", this.rmse));
        sb.append(String.format("  MAD: %.4f,\n", this.mad));
        sb.append(String.format("  R2: %.2f%%\n}", 100.0 * this.r2));
        return sb.toString();
    }
}

