/*
 * Decompiled with CFR 0.152.
 */
package smile.validation;

import java.io.Serializable;

public class ClassificationMetrics
implements Serializable {
    private static final long serialVersionUID = 2L;
    public final double fitTime;
    public final double scoreTime;
    public final int size;
    public final int error;
    public final double accuracy;
    public final double sensitivity;
    public final double specificity;
    public final double precision;
    public final double f1;
    public final double mcc;
    public final double auc;
    public final double logloss;
    public final double crossentropy;

    public ClassificationMetrics(double fitTime, double scoreTime, int size, int error, double accuracy) {
        this(fitTime, scoreTime, size, error, accuracy, Double.NaN);
    }

    public ClassificationMetrics(double fitTime, double scoreTime, int size, int error, double accuracy, double crossentropy) {
        this.fitTime = fitTime;
        this.scoreTime = scoreTime;
        this.size = size;
        this.error = error;
        this.accuracy = accuracy;
        this.crossentropy = crossentropy;
        this.sensitivity = Double.NaN;
        this.specificity = Double.NaN;
        this.precision = Double.NaN;
        this.f1 = Double.NaN;
        this.mcc = Double.NaN;
        this.auc = Double.NaN;
        this.logloss = Double.NaN;
    }

    public ClassificationMetrics(double fitTime, double scoreTime, int size, int error, double accuracy, double sensitivity, double specificity, double precision, double f1, double mcc) {
        this(fitTime, scoreTime, size, error, accuracy, sensitivity, specificity, precision, f1, mcc, Double.NaN, Double.NaN);
    }

    public ClassificationMetrics(double fitTime, double scoreTime, int size, int error, double accuracy, double sensitivity, double specificity, double precision, double f1, double mcc, double auc, double logloss) {
        this.fitTime = fitTime;
        this.scoreTime = scoreTime;
        this.size = size;
        this.error = error;
        this.accuracy = accuracy;
        this.sensitivity = sensitivity;
        this.specificity = specificity;
        this.precision = precision;
        this.f1 = f1;
        this.mcc = mcc;
        this.auc = auc;
        this.logloss = logloss;
        this.crossentropy = logloss;
    }

    public ClassificationMetrics(double fitTime, double scoreTime, int size, int error, double accuracy, double sensitivity, double specificity, double precision, double f1, double mcc, double auc, double logloss, double crossentropy) {
        this.fitTime = fitTime;
        this.scoreTime = scoreTime;
        this.size = size;
        this.error = error;
        this.accuracy = accuracy;
        this.sensitivity = sensitivity;
        this.specificity = specificity;
        this.precision = precision;
        this.f1 = f1;
        this.mcc = mcc;
        this.auc = auc;
        this.logloss = logloss;
        this.crossentropy = crossentropy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{\n");
        sb.append(String.format("  fit time: %.3f ms,\n", this.fitTime));
        sb.append(String.format("  score time: %.3f ms,\n", this.scoreTime));
        sb.append(String.format("  validation data size: %d,\n", this.size));
        sb.append(String.format("  error: %d,\n", this.error));
        sb.append(String.format("  accuracy: %.2f%%", 100.0 * this.accuracy));
        if (!Double.isNaN(this.sensitivity)) {
            sb.append(String.format(",\n  sensitivity: %.2f%%", 100.0 * this.sensitivity));
        }
        if (!Double.isNaN(this.specificity)) {
            sb.append(String.format(",\n  specificity: %.2f%%", 100.0 * this.specificity));
        }
        if (!Double.isNaN(this.precision)) {
            sb.append(String.format(",\n  precision: %.2f%%", 100.0 * this.precision));
        }
        if (!Double.isNaN(this.f1)) {
            sb.append(String.format(",\n  F1 score: %.2f%%", 100.0 * this.f1));
        }
        if (!Double.isNaN(this.mcc)) {
            sb.append(String.format(",\n  MCC: %.2f%%", 100.0 * this.mcc));
        }
        if (!Double.isNaN(this.auc)) {
            sb.append(String.format(",\n  AUC: %.2f%%", 100.0 * this.auc));
        }
        if (!Double.isNaN(this.logloss)) {
            sb.append(String.format(",\n  log loss: %.4f", this.logloss));
        } else if (!Double.isNaN(this.crossentropy)) {
            sb.append(String.format(",\n  cross entropy: %.4f", this.crossentropy));
        }
        sb.append("\n}");
        return sb.toString();
    }
}

