/*
 * Decompiled with CFR 0.152.
 */
package smile.sequence;

import java.util.Arrays;
import java.util.Properties;
import java.util.function.Function;
import smile.data.Tuple;
import smile.sequence.CRF;
import smile.sequence.SequenceLabeler;

public class CRFLabeler<T>
implements SequenceLabeler<T> {
    private static final long serialVersionUID = 2L;
    public final CRF model;
    public final Function<T, Tuple> features;

    public CRFLabeler(CRF model, Function<T, Tuple> features) {
        this.model = model;
        this.features = features;
    }

    public static <T> CRFLabeler<T> fit(T[][] sequences, int[][] labels, Function<T, Tuple> features) {
        return CRFLabeler.fit(sequences, labels, features, new Properties());
    }

    public static <T> CRFLabeler<T> fit(T[][] sequences, int[][] labels, Function<T, Tuple> features, Properties prop) {
        int ntrees = Integer.valueOf(prop.getProperty("smile.crf.trees", "100"));
        int maxDepth = Integer.valueOf(prop.getProperty("smile.crf.max.depth", "20"));
        int maxNodes = Integer.valueOf(prop.getProperty("smile.crf.max.nodes", "100"));
        int nodeSize = Integer.valueOf(prop.getProperty("smile.crf.node.size", "5"));
        double shrinkage = Double.valueOf(prop.getProperty("smile.crf.shrinkage", "1.0"));
        return CRFLabeler.fit(sequences, labels, features, ntrees, maxDepth, maxNodes, nodeSize, shrinkage);
    }

    public static <T> CRFLabeler<T> fit(T[][] sequences, int[][] labels, Function<T, Tuple> features, int ntrees, int maxDepth, int maxNodes, int nodeSize, double shrinkage) {
        if (sequences.length != labels.length) {
            throw new IllegalArgumentException("The number of observation sequences and that of label sequences are different.");
        }
        CRF model = CRF.fit((Tuple[][])Arrays.stream(sequences).map(sequence -> (Tuple[])Arrays.stream(sequence).map(symbol -> (Tuple)features.apply(symbol)).toArray(Tuple[]::new)).toArray(x$0 -> new Tuple[x$0][]), labels, ntrees, maxDepth, maxNodes, nodeSize, shrinkage);
        return new CRFLabeler<T>(model, features);
    }

    public String toString() {
        return this.model.toString();
    }

    private Tuple[] translate(T[] o) {
        return (Tuple[])Arrays.stream(o).map(symbol -> this.features.apply(symbol)).toArray(Tuple[]::new);
    }

    @Override
    public int[] predict(T[] o) {
        return this.model.predict(this.translate(o));
    }

    public int[] viterbi(T[] o) {
        return this.model.viterbi(this.translate(o));
    }
}

