/*
 * Decompiled with CFR 0.152.
 */
package smile.regression;

import smile.base.svm.LinearKernelMachine;
import smile.math.kernel.BinarySparseLinearKernel;
import smile.math.kernel.LinearKernel;
import smile.math.kernel.MercerKernel;
import smile.math.kernel.SparseLinearKernel;
import smile.regression.KernelMachine;
import smile.regression.Regression;
import smile.util.SparseArray;

public class SVR {
    public static Regression<double[]> fit(double[][] x, double[] y, double eps, double C, double tol) {
        smile.base.svm.SVR svr = new smile.base.svm.SVR(new LinearKernel(), eps, C, tol);
        final KernelMachine svm = svr.fit((T[])x, y);
        return new Regression<double[]>(){
            LinearKernelMachine model;
            {
                this.model = LinearKernelMachine.of(svm);
            }

            @Override
            public double predict(double[] x) {
                return this.model.f(x);
            }
        };
    }

    public static Regression<int[]> fit(int[][] x, double[] y, final int p, double eps, double C, double tol) {
        smile.base.svm.SVR svr = new smile.base.svm.SVR(new BinarySparseLinearKernel(), eps, C, tol);
        final KernelMachine svm = svr.fit((T[])x, y);
        return new Regression<int[]>(){
            LinearKernelMachine model;
            {
                this.model = LinearKernelMachine.binary(p, svm);
            }

            @Override
            public double predict(int[] x) {
                return this.model.f(x);
            }
        };
    }

    public static Regression<SparseArray> fit(SparseArray[] x, double[] y, final int p, double eps, double C, double tol) {
        smile.base.svm.SVR<SparseArray> svr = new smile.base.svm.SVR<SparseArray>((MercerKernel<SparseArray>)new SparseLinearKernel(), eps, C, tol);
        final KernelMachine<SparseArray> svm = svr.fit(x, y);
        return new Regression<SparseArray>(){
            LinearKernelMachine model;
            {
                this.model = LinearKernelMachine.sparse(p, svm);
            }

            @Override
            public double predict(SparseArray x) {
                return this.model.f(x);
            }
        };
    }

    public static <T> KernelMachine<T> fit(T[] x, double[] y, MercerKernel<T> kernel, double eps, double C, double tol) {
        smile.base.svm.SVR<T> svr = new smile.base.svm.SVR<T>(kernel, eps, C, tol);
        return svr.fit(x, y);
    }
}

