/*
 * Decompiled with CFR 0.152.
 */
package smile.projection;

import java.io.Serializable;
import smile.math.MathEx;
import smile.math.matrix.Matrix;
import smile.projection.LinearProjection;

public class GHA
implements LinearProjection,
Serializable {
    private static final long serialVersionUID = 2L;
    private int p;
    private int n;
    private double r;
    private Matrix projection;
    private double[] y;
    private double[] wy;

    public GHA(int n, int p, double r) {
        if (n < 2) {
            throw new IllegalArgumentException("Invalid dimension of input space: " + n);
        }
        if (p < 1 || p > n) {
            throw new IllegalArgumentException("Invalid dimension of feature space: " + p);
        }
        this.n = n;
        this.p = p;
        this.r = r;
        this.y = new double[p];
        this.wy = new double[n];
        this.projection = new Matrix(p, n);
        for (int i = 0; i < p; ++i) {
            for (int j = 0; j < n; ++j) {
                this.projection.set(i, j, 0.1 * MathEx.random());
            }
        }
    }

    public GHA(double[][] w, double r) {
        this.p = w.length;
        this.n = w[0].length;
        this.r = r;
        this.y = new double[this.p];
        this.wy = new double[this.n];
        this.projection = new Matrix(w);
    }

    @Override
    public Matrix getProjection() {
        return this.projection;
    }

    public double getLearningRate() {
        return this.r;
    }

    public GHA setLearningRate(double r) {
        this.r = r;
        return this;
    }

    public double update(double[] x) {
        if (x.length != this.n) {
            throw new IllegalArgumentException(String.format("Invalid input vector size: %d, expected: %d", x.length, this.n));
        }
        this.projection.mv(x, this.y);
        for (int j = 0; j < this.p; ++j) {
            for (int i = 0; i < this.n; ++i) {
                double delta = x[i];
                for (int l = 0; l <= j; ++l) {
                    delta -= this.projection.get(l, i) * this.y[l];
                }
                this.projection.add(j, i, this.r * this.y[j] * delta);
                if (!Double.isInfinite(this.projection.get(j, i))) continue;
                throw new IllegalStateException("GHA lost convergence. Lower learning rate?");
            }
        }
        this.projection.mv(x, this.y);
        this.projection.tv(this.y, this.wy);
        return MathEx.squaredDistance((double[])x, (double[])this.wy);
    }
}

