/*
 * Decompiled with CFR 0.152.
 */
package smile.neighbor;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import smile.math.distance.Distance;
import smile.neighbor.KNNSearch;
import smile.neighbor.NearestNeighborSearch;
import smile.neighbor.Neighbor;
import smile.neighbor.NeighborBuilder;
import smile.neighbor.RNNSearch;
import smile.sort.HeapSelect;

public class LinearSearch<T>
implements NearestNeighborSearch<T, T>,
KNNSearch<T, T>,
RNNSearch<T, T>,
Serializable {
    private static final long serialVersionUID = 2L;
    private T[] data;
    private Distance<T> distance;

    public LinearSearch(T[] dataset, Distance<T> distance) {
        this.data = dataset;
        this.distance = distance;
    }

    public String toString() {
        return String.format("Linear Search (%s)", this.distance);
    }

    @Override
    public Neighbor<T, T> nearest(T q) {
        double[] dist = ((Stream)Arrays.stream(this.data).parallel()).mapToDouble(x -> this.distance.d(q, x)).toArray();
        int index = -1;
        double nearest = Double.MAX_VALUE;
        for (int i = 0; i < dist.length; ++i) {
            if (!(dist[i] < nearest) || q == this.data[i]) continue;
            index = i;
            nearest = dist[i];
        }
        return Neighbor.of(this.data[index], index, nearest);
    }

    @Override
    public Neighbor<T, T>[] knn(T q, int k) {
        int i;
        if (k <= 0) {
            throw new IllegalArgumentException("Invalid k: " + k);
        }
        if (k > this.data.length) {
            throw new IllegalArgumentException("Neighbor array length is larger than the data size");
        }
        double[] dist = ((Stream)Arrays.stream(this.data).parallel()).mapToDouble(x -> this.distance.d(q, x)).toArray();
        HeapSelect heap = new HeapSelect(NeighborBuilder.class, k);
        for (i = 0; i < k; ++i) {
            heap.add(new NeighborBuilder());
        }
        for (i = 0; i < dist.length; ++i) {
            NeighborBuilder datum = (NeighborBuilder)heap.peek();
            if (!(dist[i] < datum.distance) || q == this.data[i]) continue;
            datum.distance = dist[i];
            datum.index = i;
            datum.key = this.data[i];
            datum.value = this.data[i];
            heap.heapify();
        }
        heap.sort();
        return (Neighbor[])Arrays.stream(heap.toArray()).map(NeighborBuilder::toNeighbor).toArray(Neighbor[]::new);
    }

    @Override
    public void range(T q, double radius, List<Neighbor<T, T>> neighbors) {
        if (radius <= 0.0) {
            throw new IllegalArgumentException("Invalid radius: " + radius);
        }
        double[] dist = ((Stream)Arrays.stream(this.data).parallel()).mapToDouble(x -> this.distance.d(q, x)).toArray();
        for (int i = 0; i < this.data.length; ++i) {
            if (!(dist[i] <= radius) || q == this.data[i]) continue;
            neighbors.add(Neighbor.of(this.data[i], i, dist[i]));
        }
    }
}

