/*
 * Decompiled with CFR 0.152.
 */
package smile.feature;

import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.measure.NominalScale;
import smile.data.type.StructField;
import smile.data.type.StructType;

public class SparseOneHotEncoder {
    private StructType schema;
    private int[] base;

    public SparseOneHotEncoder(StructType schema) {
        this.schema = schema;
        this.base = new int[schema.length()];
        for (int i = 0; i < this.base.length; ++i) {
            StructField field = schema.field(i);
            if (field.measure == null || !(field.measure instanceof NominalScale)) {
                throw new IllegalArgumentException("Non-nominal attribute: " + field);
            }
            if (i >= this.base.length - 1) continue;
            this.base[i + 1] = this.base[i] + ((NominalScale)field.measure).size();
        }
    }

    public int[] apply(Tuple x) {
        int[] features = new int[this.schema.length()];
        for (int i = 0; i < features.length; ++i) {
            features[i] = x.getInt(i) + this.base[i];
        }
        return features;
    }

    public int[][] apply(DataFrame data) {
        return (int[][])data.stream().map(this::apply).toArray(x$0 -> new int[x$0][]);
    }
}

