/*
 * Decompiled with CFR 0.152.
 */
package smile.feature;

import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import smile.data.DataFrame;
import smile.data.type.StructType;
import smile.feature.Standardizer;
import smile.sort.IQAgent;

public class RobustStandardizer
extends Standardizer {
    private static final long serialVersionUID = 2L;

    public RobustStandardizer(StructType schema, double[] median, double[] iqr) {
        super(schema, median, iqr);
    }

    public static RobustStandardizer fit(DataFrame data) {
        if (data.isEmpty()) {
            throw new IllegalArgumentException("Empty data frame");
        }
        StructType schema = data.schema();
        double[] median = new double[schema.length()];
        double[] iqr = new double[schema.length()];
        for (int i = 0; i < median.length; ++i) {
            if (!schema.field(i).isNumeric()) continue;
            int col = i;
            IQAgent agent = new IQAgent();
            ((Stream)data.stream().sequential()).forEach(t -> agent.add(t.getDouble(col)));
            median[i] = agent.quantile(0.5);
            iqr[i] = agent.quantile(0.75) - agent.quantile(0.25);
        }
        return new RobustStandardizer(schema, median, iqr);
    }

    public static RobustStandardizer fit(double[][] data) {
        return RobustStandardizer.fit(DataFrame.of((double[][])data, (String[])new String[0]));
    }

    @Override
    public String toString() {
        return IntStream.range(0, this.mu.length).mapToObj(i -> String.format("%s[%.4f, %.4f]", this.schema.field((int)i).name, this.mu[i], this.std[i])).collect(Collectors.joining(",", "RobustStandardizer(", ")"));
    }
}

