/*
 * Decompiled with CFR 0.152.
 */
package smile.feature;

import smile.data.CategoricalEncoder;
import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.type.StructType;
import smile.feature.FeatureTransform;
import smile.math.MathEx;

public class Normalizer
implements FeatureTransform {
    private static final long serialVersionUID = 2L;
    private Norm norm;

    public Normalizer() {
        this(Norm.L2);
    }

    public Normalizer(Norm norm) {
        this.norm = norm;
    }

    @Override
    public double[] transform(double[] x) {
        double scale;
        switch (this.norm) {
            case L1: {
                scale = MathEx.norm1((double[])x);
                break;
            }
            case L2: {
                scale = MathEx.norm2((double[])x);
                break;
            }
            case Inf: {
                scale = MathEx.normInf((double[])x);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type of norm: " + (Object)((Object)this.norm));
            }
        }
        double[] y = new double[x.length];
        if (MathEx.isZero((double)scale)) {
            System.arraycopy(x, 0, y, 0, x.length);
        } else {
            for (int i = 0; i < x.length; ++i) {
                y[i] = x[i] / scale;
            }
        }
        return y;
    }

    @Override
    public Tuple transform(Tuple x) {
        double[] y = this.transform(x.toArray(false, CategoricalEncoder.ONE_HOT));
        return Tuple.of((double[])y, (StructType)x.schema());
    }

    @Override
    public DataFrame transform(DataFrame data) {
        return DataFrame.of(data.stream().map(this::transform));
    }

    public String toString() {
        return String.format("Normalizer(%s)", new Object[]{this.norm});
    }

    public static enum Norm {
        L1,
        L2,
        Inf;

    }
}

