/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering;

import java.util.ArrayList;
import java.util.Arrays;
import smile.clustering.PartitionClustering;
import smile.math.MathEx;
import smile.math.distance.Distance;
import smile.neighbor.KDTree;
import smile.neighbor.LinearSearch;
import smile.neighbor.Neighbor;
import smile.neighbor.RNNSearch;

public class DBSCAN<T>
extends PartitionClustering {
    private static final long serialVersionUID = 2L;
    public final double minPts;
    public final double radius;
    private RNNSearch<T, T> nns;

    public DBSCAN(int minPts, double radius, RNNSearch<T, T> nns, int k, int[] y) {
        super(k, y);
        this.minPts = minPts;
        this.radius = radius;
        this.nns = nns;
    }

    public static DBSCAN<double[]> fit(double[][] data, int minPts, double radius) {
        return DBSCAN.fit(data, new KDTree(data, (E[])data), minPts, radius);
    }

    public static <T> DBSCAN<T> fit(T[] data, Distance<T> distance, int minPts, double radius) {
        return DBSCAN.fit(data, new LinearSearch<T>(data, distance), minPts, radius);
    }

    public static <T> DBSCAN<T> fit(T[] data, RNNSearch<T, T> nns, int minPts, double radius) {
        if (minPts < 1) {
            throw new IllegalArgumentException("Invalid minPts: " + minPts);
        }
        if (radius <= 0.0) {
            throw new IllegalArgumentException("Invalid radius: " + radius);
        }
        int QUEUED = -2;
        int UNDEFINED = -1;
        int k = 0;
        int n = data.length;
        int[] y = new int[n];
        Arrays.fill(y, -1);
        for (int i = 0; i < data.length; ++i) {
            if (y[i] != -1) continue;
            ArrayList neighbors = new ArrayList();
            nns.range(data[i], radius, neighbors);
            if (neighbors.size() < minPts) {
                y[i] = Integer.MAX_VALUE;
                continue;
            }
            y[i] = k;
            for (Neighbor neighbor : neighbors) {
                if (y[neighbor.index] != -1) continue;
                y[neighbor.index] = -2;
            }
            for (int j = 0; j < neighbors.size(); ++j) {
                Neighbor neighbor = (Neighbor)neighbors.get(j);
                int index = neighbor.index;
                if (y[index] == Integer.MAX_VALUE) {
                    y[index] = k;
                }
                if (y[index] != -1 && y[index] != -2) continue;
                y[index] = k;
                ArrayList secondaryNeighbors = new ArrayList();
                nns.range(neighbor.key, radius, secondaryNeighbors);
                if (secondaryNeighbors.size() < minPts) continue;
                for (Neighbor neighbor2 : secondaryNeighbors) {
                    int label = y[neighbor2.index];
                    if (label == -1) {
                        y[neighbor2.index] = -2;
                    }
                    if (label != -1 && label != Integer.MAX_VALUE) continue;
                    neighbors.add(neighbor2);
                }
            }
            ++k;
        }
        return new DBSCAN<T>(minPts, radius, nns, k, y);
    }

    public int predict(T x) {
        ArrayList neighbors = new ArrayList();
        this.nns.range(x, this.radius, neighbors);
        if ((double)neighbors.size() < this.minPts) {
            return Integer.MAX_VALUE;
        }
        int[] count = new int[this.k + 1];
        for (Neighbor neighbor : neighbors) {
            int yi = this.y[neighbor.index];
            if (yi == Integer.MAX_VALUE) {
                yi = this.k;
            }
            int n = yi;
            count[n] = count[n] + 1;
        }
        int y = MathEx.whichMax((int[])count);
        return y == this.k ? Integer.MAX_VALUE : y;
    }
}

