/*
 * Decompiled with CFR 0.152.
 */
package smile.classification;

import java.util.Arrays;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.classification.ClassLabels;
import smile.classification.Classifier;
import smile.classification.DataFrameClassifier;
import smile.classification.PlattScaling;
import smile.classification.SoftClassifier;
import smile.data.DataFrame;
import smile.data.Tuple;
import smile.data.formula.Formula;
import smile.data.type.StructType;
import smile.math.MathEx;
import smile.util.IntSet;

public class OneVersusRest<T>
implements SoftClassifier<T> {
    private static final long serialVersionUID = 2L;
    private static final Logger logger = LoggerFactory.getLogger(OneVersusRest.class);
    private int k;
    private Classifier<T>[] classifiers;
    private PlattScaling[] platts;
    private IntSet labels;

    public OneVersusRest(Classifier<T>[] classifiers, PlattScaling[] platts) {
        this(classifiers, platts, IntSet.of((int)classifiers.length));
    }

    public OneVersusRest(Classifier<T>[] classifiers, PlattScaling[] platts, IntSet labels) {
        this.classifiers = classifiers;
        this.platts = platts;
        this.k = classifiers.length;
        this.labels = labels;
    }

    public static <T> OneVersusRest<T> fit(T[] x, int[] y, BiFunction<T[], int[], Classifier<T>> trainer) {
        return OneVersusRest.fit(x, y, 1, -1, trainer);
    }

    public static <T> OneVersusRest<T> fit(T[] x, int[] y, int pos, int neg, BiFunction<T[], int[], Classifier<T>> trainer) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and Y don't match: %d != %d", x.length, y.length));
        }
        ClassLabels codec = ClassLabels.fit(y);
        int k = codec.k;
        if (k <= 2) {
            throw new IllegalArgumentException(String.format("Only %d classes", k));
        }
        int n = x.length;
        y = codec.y;
        Classifier[] classifiers = new Classifier[k];
        PlattScaling[] platts = null;
        for (int i = 0; i < k; ++i) {
            int[] yi = new int[n];
            for (int j = 0; j < n; ++j) {
                yi[j] = y[j] == i ? pos : neg;
            }
            classifiers[i] = trainer.apply((T[][])x, yi);
            if (i == 0) {
                try {
                    classifiers[0].score(x[0]);
                    platts = new PlattScaling[k];
                }
                catch (UnsupportedOperationException ex) {
                    logger.info("The classifier doesn't support score function. Don't fit Platt scaling.");
                }
            }
            if (platts == null) continue;
            platts[i] = PlattScaling.fit(classifiers[i], x, yi);
        }
        return new OneVersusRest<T>(classifiers, platts);
    }

    public static DataFrameClassifier fit(final Formula formula, DataFrame data, BiFunction<Formula, DataFrame, DataFrameClassifier> trainer) {
        Tuple[] x = (Tuple[])data.stream().toArray(Tuple[]::new);
        int[] y = formula.y(data).toIntArray();
        final OneVersusRest<Tuple> model = OneVersusRest.fit(x, y, 1, 0, (rows, labels) -> {
            DataFrame df = DataFrame.of(Arrays.asList(rows));
            return (Classifier)trainer.apply(formula, df);
        });
        final StructType schema = formula.x((Tuple)data.get(0)).schema();
        return new DataFrameClassifier(){

            @Override
            public int predict(Tuple x) {
                return model.predict(x);
            }

            @Override
            public Formula formula() {
                return formula;
            }

            @Override
            public StructType schema() {
                return schema;
            }
        };
    }

    @Override
    public int predict(T x) {
        int y = 0;
        double maxf = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.k; ++i) {
            double f = this.platts[i].scale(this.classifiers[i].score(x));
            if (!(f > maxf)) continue;
            y = i;
            maxf = f;
        }
        return this.labels.valueOf(y);
    }

    @Override
    public int predict(T x, double[] posteriori) {
        if (this.platts == null) {
            throw new UnsupportedOperationException("Platt scaling is not available");
        }
        for (int i = 0; i < this.k; ++i) {
            posteriori[i] = this.platts[i].scale(this.classifiers[i].score(x));
        }
        MathEx.unitize1((double[])posteriori);
        return this.labels.valueOf(MathEx.whichMax((double[])posteriori));
    }
}

