/*
 * Decompiled with CFR 0.152.
 */
package smile.base.svm;

import java.io.Serializable;
import smile.classification.SVM;
import smile.math.kernel.MercerKernel;

public class KernelMachine<T>
implements Serializable {
    private static final long serialVersionUID = 2L;
    MercerKernel<T> kernel;
    T[] instances;
    double[] w;
    double b;

    public KernelMachine(MercerKernel<T> kernel, T[] instances, double[] weight) {
        this(kernel, instances, weight, 0.0);
    }

    public KernelMachine(MercerKernel<T> kernel, T[] instances, double[] weight, double b) {
        this.kernel = kernel;
        this.instances = instances;
        this.w = weight;
        this.b = b;
    }

    public MercerKernel<T> kernel() {
        return this.kernel;
    }

    public T[] instances() {
        return this.instances;
    }

    public double[] weights() {
        return this.w;
    }

    public double intercept() {
        return this.b;
    }

    public double score(T x) {
        double f = this.b;
        for (int i = 0; i < this.instances.length; ++i) {
            f += this.w[i] * this.kernel.k(x, this.instances[i]);
        }
        return f;
    }

    public SVM<T> toSVM() {
        return new SVM<T>(this.kernel, this.instances, this.w, this.b);
    }

    public String toString() {
        return String.format("Kernel Machine (%s): %d vectors, intercept = %.4f", this.kernel, this.instances.length, this.b);
    }
}

