/*
 * Decompiled with CFR 0.152.
 */
package smile.validation;

import smile.classification.Classifier;
import smile.classification.ClassifierTrainer;
import smile.math.Math;
import smile.regression.Regression;
import smile.regression.RegressionTrainer;
import smile.validation.Accuracy;
import smile.validation.Bootstrap;
import smile.validation.ClassificationMeasure;
import smile.validation.CrossValidation;
import smile.validation.LOOCV;
import smile.validation.RMSE;
import smile.validation.RegressionMeasure;

public class Validation {
    public static <T> double test(Classifier<T> classifier, T[] x, int[] y) {
        int n = x.length;
        int[] predictions = new int[n];
        for (int i = 0; i < n; ++i) {
            predictions[i] = classifier.predict(x[i]);
        }
        return new Accuracy().measure(y, predictions);
    }

    public static <T> double test(Regression<T> regression, T[] x, double[] y) {
        int n = x.length;
        double[] predictions = new double[n];
        for (int i = 0; i < n; ++i) {
            predictions[i] = regression.predict(x[i]);
        }
        return new RMSE().measure(y, predictions);
    }

    public static <T> double test(Classifier<T> classifier, T[] x, int[] y, ClassificationMeasure measure) {
        int n = x.length;
        int[] predictions = new int[n];
        for (int i = 0; i < n; ++i) {
            predictions[i] = classifier.predict(x[i]);
        }
        return measure.measure(y, predictions);
    }

    public static <T> double[] test(Classifier<T> classifier, T[] x, int[] y, ClassificationMeasure[] measures) {
        int n = x.length;
        int[] predictions = new int[n];
        for (int i = 0; i < n; ++i) {
            predictions[i] = classifier.predict(x[i]);
        }
        int m = measures.length;
        double[] results = new double[m];
        for (int i = 0; i < m; ++i) {
            results[i] = measures[i].measure(y, predictions);
        }
        return results;
    }

    public static <T> double test(Regression<T> regression, T[] x, double[] y, RegressionMeasure measure) {
        int n = x.length;
        double[] predictions = new double[n];
        for (int i = 0; i < n; ++i) {
            predictions[i] = regression.predict(x[i]);
        }
        return measure.measure(y, predictions);
    }

    public static <T> double[] test(Regression<T> regression, T[] x, double[] y, RegressionMeasure[] measures) {
        int n = x.length;
        double[] predictions = new double[n];
        for (int i = 0; i < n; ++i) {
            predictions[i] = regression.predict(x[i]);
        }
        int m = measures.length;
        double[] results = new double[m];
        for (int i = 0; i < m; ++i) {
            results[i] = measures[i].measure(y, predictions);
        }
        return results;
    }

    public static <T> double loocv(ClassifierTrainer<T> trainer, T[] x, int[] y) {
        int m = 0;
        int n = x.length;
        LOOCV loocv = new LOOCV(n);
        for (int i = 0; i < n; ++i) {
            int[] trainy;
            Object[] trainx = Math.slice((Object[])x, (int[])loocv.train[i]);
            Classifier<Object> classifier = trainer.train(trainx, trainy = Math.slice((int[])y, (int[])loocv.train[i]));
            if (classifier.predict(x[loocv.test[i]]) != y[loocv.test[i]]) continue;
            ++m;
        }
        return (double)m / (double)n;
    }

    public static <T> double loocv(RegressionTrainer<T> trainer, T[] x, double[] y) {
        double rmse = 0.0;
        int n = x.length;
        LOOCV loocv = new LOOCV(n);
        for (int i = 0; i < n; ++i) {
            Object[] trainx = Math.slice((Object[])x, (int[])loocv.train[i]);
            double[] trainy = Math.slice((double[])y, (int[])loocv.train[i]);
            Regression<Object> model = trainer.train(trainx, trainy);
            rmse += Math.sqr((double)(model.predict(x[loocv.test[i]]) - y[loocv.test[i]]));
        }
        return Math.sqrt((double)(rmse / (double)n));
    }

    public static <T> double loocv(ClassifierTrainer<T> trainer, T[] x, int[] y, ClassificationMeasure measure) {
        int n = x.length;
        int[] predictions = new int[n];
        LOOCV loocv = new LOOCV(n);
        for (int i = 0; i < n; ++i) {
            Object[] trainx = Math.slice((Object[])x, (int[])loocv.train[i]);
            int[] trainy = Math.slice((int[])y, (int[])loocv.train[i]);
            Classifier<Object> classifier = trainer.train(trainx, trainy);
            predictions[loocv.test[i]] = classifier.predict(x[loocv.test[i]]);
        }
        return measure.measure(y, predictions);
    }

    public static <T> double[] loocv(ClassifierTrainer<T> trainer, T[] x, int[] y, ClassificationMeasure[] measures) {
        int n = x.length;
        int[] predictions = new int[n];
        LOOCV loocv = new LOOCV(n);
        for (int i = 0; i < n; ++i) {
            Object[] trainx = Math.slice((Object[])x, (int[])loocv.train[i]);
            int[] trainy = Math.slice((int[])y, (int[])loocv.train[i]);
            Classifier<Object> classifier = trainer.train(trainx, trainy);
            predictions[loocv.test[i]] = classifier.predict(x[loocv.test[i]]);
        }
        int m = measures.length;
        double[] results = new double[m];
        for (int i = 0; i < m; ++i) {
            results[i] = measures[i].measure(y, predictions);
        }
        return results;
    }

    public static <T> double loocv(RegressionTrainer<T> trainer, T[] x, double[] y, RegressionMeasure measure) {
        int n = x.length;
        double[] predictions = new double[n];
        LOOCV loocv = new LOOCV(n);
        for (int i = 0; i < n; ++i) {
            Object[] trainx = Math.slice((Object[])x, (int[])loocv.train[i]);
            double[] trainy = Math.slice((double[])y, (int[])loocv.train[i]);
            Regression<Object> model = trainer.train(trainx, trainy);
            predictions[loocv.test[i]] = model.predict(x[loocv.test[i]]);
        }
        return measure.measure(y, predictions);
    }

    public static <T> double[] loocv(RegressionTrainer<T> trainer, T[] x, double[] y, RegressionMeasure[] measures) {
        int n = x.length;
        double[] predictions = new double[n];
        LOOCV loocv = new LOOCV(n);
        for (int i = 0; i < n; ++i) {
            Object[] trainx = Math.slice((Object[])x, (int[])loocv.train[i]);
            double[] trainy = Math.slice((double[])y, (int[])loocv.train[i]);
            Regression<Object> model = trainer.train(trainx, trainy);
            predictions[loocv.test[i]] = model.predict(x[loocv.test[i]]);
        }
        int m = measures.length;
        double[] results = new double[m];
        for (int i = 0; i < m; ++i) {
            results[i] = measures[i].measure(y, predictions);
        }
        return results;
    }

    public static <T> double cv(int k, ClassifierTrainer<T> trainer, T[] x, int[] y) {
        if (k < 2) {
            throw new IllegalArgumentException("Invalid k for k-fold cross validation: " + k);
        }
        int n = x.length;
        int[] predictions = new int[n];
        CrossValidation cv = new CrossValidation(n, k);
        for (int i = 0; i < k; ++i) {
            Object[] trainx = Math.slice((Object[])x, (int[])cv.train[i]);
            int[] trainy = Math.slice((int[])y, (int[])cv.train[i]);
            Classifier<Object> classifier = trainer.train(trainx, trainy);
            for (int j : cv.test[i]) {
                predictions[j] = classifier.predict(x[j]);
            }
        }
        return new Accuracy().measure(y, predictions);
    }

    public static <T> double cv(int k, RegressionTrainer<T> trainer, T[] x, double[] y) {
        if (k < 2) {
            throw new IllegalArgumentException("Invalid k for k-fold cross validation: " + k);
        }
        int n = x.length;
        double[] predictions = new double[n];
        CrossValidation cv = new CrossValidation(n, k);
        for (int i = 0; i < k; ++i) {
            Object[] trainx = Math.slice((Object[])x, (int[])cv.train[i]);
            double[] trainy = Math.slice((double[])y, (int[])cv.train[i]);
            Regression<Object> model = trainer.train(trainx, trainy);
            for (int j : cv.test[i]) {
                predictions[j] = model.predict(x[j]);
            }
        }
        return new RMSE().measure(y, predictions);
    }

    public static <T> double cv(int k, ClassifierTrainer<T> trainer, T[] x, int[] y, ClassificationMeasure measure) {
        if (k < 2) {
            throw new IllegalArgumentException("Invalid k for k-fold cross validation: " + k);
        }
        int n = x.length;
        int[] predictions = new int[n];
        CrossValidation cv = new CrossValidation(n, k);
        for (int i = 0; i < k; ++i) {
            Object[] trainx = Math.slice((Object[])x, (int[])cv.train[i]);
            int[] trainy = Math.slice((int[])y, (int[])cv.train[i]);
            Classifier<Object> classifier = trainer.train(trainx, trainy);
            for (int j : cv.test[i]) {
                predictions[j] = classifier.predict(x[j]);
            }
        }
        return measure.measure(y, predictions);
    }

    public static <T> double[] cv(int k, ClassifierTrainer<T> trainer, T[] x, int[] y, ClassificationMeasure[] measures) {
        if (k < 2) {
            throw new IllegalArgumentException("Invalid k for k-fold cross validation: " + k);
        }
        int n = x.length;
        int[] predictions = new int[n];
        CrossValidation cv = new CrossValidation(n, k);
        for (int i = 0; i < k; ++i) {
            Object[] trainx = Math.slice((Object[])x, (int[])cv.train[i]);
            int[] trainy = Math.slice((int[])y, (int[])cv.train[i]);
            Classifier<Object> classifier = trainer.train(trainx, trainy);
            for (int j : cv.test[i]) {
                predictions[j] = classifier.predict(x[j]);
            }
        }
        int m = measures.length;
        double[] results = new double[m];
        for (int i = 0; i < m; ++i) {
            results[i] = measures[i].measure(y, predictions);
        }
        return results;
    }

    public static <T> double cv(int k, RegressionTrainer<T> trainer, T[] x, double[] y, RegressionMeasure measure) {
        if (k < 2) {
            throw new IllegalArgumentException("Invalid k for k-fold cross validation: " + k);
        }
        int n = x.length;
        double[] predictions = new double[n];
        CrossValidation cv = new CrossValidation(n, k);
        for (int i = 0; i < k; ++i) {
            Object[] trainx = Math.slice((Object[])x, (int[])cv.train[i]);
            double[] trainy = Math.slice((double[])y, (int[])cv.train[i]);
            Regression<Object> model = trainer.train(trainx, trainy);
            for (int j : cv.test[i]) {
                predictions[j] = model.predict(x[j]);
            }
        }
        return measure.measure(y, predictions);
    }

    public static <T> double[] cv(int k, RegressionTrainer<T> trainer, T[] x, double[] y, RegressionMeasure[] measures) {
        if (k < 2) {
            throw new IllegalArgumentException("Invalid k for k-fold cross validation: " + k);
        }
        int n = x.length;
        double[] predictions = new double[n];
        CrossValidation cv = new CrossValidation(n, k);
        for (int i = 0; i < k; ++i) {
            Object[] trainx = Math.slice((Object[])x, (int[])cv.train[i]);
            double[] trainy = Math.slice((double[])y, (int[])cv.train[i]);
            Regression<Object> model = trainer.train(trainx, trainy);
            for (int j : cv.test[i]) {
                predictions[j] = model.predict(x[j]);
            }
        }
        int m = measures.length;
        double[] results = new double[m];
        for (int i = 0; i < m; ++i) {
            results[i] = measures[i].measure(y, predictions);
        }
        return results;
    }

    public static <T> double[] bootstrap(int k, ClassifierTrainer<T> trainer, T[] x, int[] y) {
        if (k < 2) {
            throw new IllegalArgumentException("Invalid k for k-fold bootstrap: " + k);
        }
        int n = x.length;
        double[] results = new double[k];
        Accuracy measure = new Accuracy();
        Bootstrap bootstrap = new Bootstrap(n, k);
        for (int i = 0; i < k; ++i) {
            Object[] trainx = Math.slice((Object[])x, (int[])bootstrap.train[i]);
            int[] trainy = Math.slice((int[])y, (int[])bootstrap.train[i]);
            Classifier<Object> classifier = trainer.train(trainx, trainy);
            int nt = bootstrap.test[i].length;
            int[] truth = new int[nt];
            int[] predictions = new int[nt];
            for (int j = 0; j < nt; ++j) {
                int l = bootstrap.test[i][j];
                truth[j] = y[l];
                predictions[j] = classifier.predict(x[l]);
            }
            results[i] = measure.measure(truth, predictions);
        }
        return results;
    }

    public static <T> double[] bootstrap(int k, RegressionTrainer<T> trainer, T[] x, double[] y) {
        if (k < 2) {
            throw new IllegalArgumentException("Invalid k for k-fold bootstrap: " + k);
        }
        int n = x.length;
        double[] results = new double[k];
        RMSE measure = new RMSE();
        Bootstrap bootstrap = new Bootstrap(n, k);
        for (int i = 0; i < k; ++i) {
            Object[] trainx = Math.slice((Object[])x, (int[])bootstrap.train[i]);
            double[] trainy = Math.slice((double[])y, (int[])bootstrap.train[i]);
            Regression<Object> model = trainer.train(trainx, trainy);
            int nt = bootstrap.test[i].length;
            double[] truth = new double[nt];
            double[] predictions = new double[nt];
            for (int j = 0; j < nt; ++j) {
                int l = bootstrap.test[i][j];
                truth[j] = y[l];
                predictions[j] = model.predict(x[l]);
            }
            results[i] = measure.measure(truth, predictions);
        }
        return results;
    }

    public static <T> double[] bootstrap(int k, ClassifierTrainer<T> trainer, T[] x, int[] y, ClassificationMeasure measure) {
        if (k < 2) {
            throw new IllegalArgumentException("Invalid k for k-fold bootstrap: " + k);
        }
        int n = x.length;
        double[] results = new double[k];
        Bootstrap bootstrap = new Bootstrap(n, k);
        for (int i = 0; i < k; ++i) {
            Object[] trainx = Math.slice((Object[])x, (int[])bootstrap.train[i]);
            int[] trainy = Math.slice((int[])y, (int[])bootstrap.train[i]);
            Classifier<Object> classifier = trainer.train(trainx, trainy);
            int nt = bootstrap.test[i].length;
            int[] truth = new int[nt];
            int[] predictions = new int[nt];
            for (int j = 0; j < nt; ++j) {
                int l = bootstrap.test[i][j];
                truth[j] = y[l];
                predictions[j] = classifier.predict(x[l]);
            }
            results[i] = measure.measure(truth, predictions);
        }
        return results;
    }

    public static <T> double[][] bootstrap(int k, ClassifierTrainer<T> trainer, T[] x, int[] y, ClassificationMeasure[] measures) {
        if (k < 2) {
            throw new IllegalArgumentException("Invalid k for k-fold bootstrap: " + k);
        }
        int n = x.length;
        int m = measures.length;
        double[][] results = new double[k][m];
        Bootstrap bootstrap = new Bootstrap(n, k);
        for (int i = 0; i < k; ++i) {
            int j;
            Object[] trainx = Math.slice((Object[])x, (int[])bootstrap.train[i]);
            int[] trainy = Math.slice((int[])y, (int[])bootstrap.train[i]);
            Classifier<Object> classifier = trainer.train(trainx, trainy);
            int nt = bootstrap.test[i].length;
            int[] truth = new int[nt];
            int[] predictions = new int[nt];
            for (j = 0; j < nt; ++j) {
                int l = bootstrap.test[i][j];
                truth[j] = y[l];
                predictions[j] = classifier.predict(x[l]);
            }
            for (j = 0; j < m; ++j) {
                results[i][j] = measures[j].measure(truth, predictions);
            }
        }
        return results;
    }

    public static <T> double[] bootstrap(int k, RegressionTrainer<T> trainer, T[] x, double[] y, RegressionMeasure measure) {
        if (k < 2) {
            throw new IllegalArgumentException("Invalid k for k-fold bootstrap: " + k);
        }
        int n = x.length;
        double[] results = new double[k];
        Bootstrap bootstrap = new Bootstrap(n, k);
        for (int i = 0; i < k; ++i) {
            Object[] trainx = Math.slice((Object[])x, (int[])bootstrap.train[i]);
            double[] trainy = Math.slice((double[])y, (int[])bootstrap.train[i]);
            Regression<Object> model = trainer.train(trainx, trainy);
            int nt = bootstrap.test[i].length;
            double[] truth = new double[nt];
            double[] predictions = new double[nt];
            for (int j = 0; j < nt; ++j) {
                int l = bootstrap.test[i][j];
                truth[j] = y[l];
                predictions[j] = model.predict(x[l]);
            }
            results[i] = measure.measure(truth, predictions);
        }
        return results;
    }

    public static <T> double[][] bootstrap(int k, RegressionTrainer<T> trainer, T[] x, double[] y, RegressionMeasure[] measures) {
        if (k < 2) {
            throw new IllegalArgumentException("Invalid k for k-fold bootstrap: " + k);
        }
        int n = x.length;
        int m = measures.length;
        double[][] results = new double[k][m];
        Bootstrap bootstrap = new Bootstrap(n, k);
        for (int i = 0; i < k; ++i) {
            int j;
            Object[] trainx = Math.slice((Object[])x, (int[])bootstrap.train[i]);
            double[] trainy = Math.slice((double[])y, (int[])bootstrap.train[i]);
            Regression<Object> model = trainer.train(trainx, trainy);
            int nt = bootstrap.test[i].length;
            double[] truth = new double[nt];
            double[] predictions = new double[nt];
            for (j = 0; j < nt; ++j) {
                int l = bootstrap.test[i][j];
                truth[j] = y[l];
                predictions[j] = model.predict(x[l]);
            }
            for (j = 0; j < m; ++j) {
                results[i][j] = measures[j].measure(truth, predictions);
            }
        }
        return results;
    }
}

