/*
 * Decompiled with CFR 0.152.
 */
package smile.validation;

import smile.math.Math;

public class Bootstrap {
    public final int k;
    public final int[][] train;
    public final int[][] test;

    public Bootstrap(int n, int k) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid sample size: " + n);
        }
        if (k < 0) {
            throw new IllegalArgumentException("Invalid number of bootstrap: " + k);
        }
        this.k = k;
        this.train = new int[k][n];
        this.test = new int[k][];
        for (int j = 0; j < k; ++j) {
            int i;
            boolean[] hit = new boolean[n];
            int hits = 0;
            for (i = 0; i < n; ++i) {
                int r;
                this.train[j][i] = r = Math.randomInt((int)n);
                if (hit[r]) continue;
                ++hits;
                hit[r] = true;
            }
            this.test[j] = new int[n - hits];
            int p = 0;
            for (i = 0; i < n; ++i) {
                if (hit[i]) continue;
                this.test[j][p++] = i;
            }
        }
    }
}

