/*
 * Decompiled with CFR 0.152.
 */
package smile.feature;

import smile.data.Attribute;
import smile.data.NominalAttribute;

public class SparseOneHotEncoder {
    private NominalAttribute[] attributes;
    private int[] base;

    public SparseOneHotEncoder(Attribute[] attributes) {
        int p = attributes.length;
        this.attributes = new NominalAttribute[p];
        this.base = new int[p];
        for (int i = 0; i < p; ++i) {
            Attribute attribute = attributes[i];
            if (attribute instanceof NominalAttribute) {
                NominalAttribute nominal;
                this.attributes[i] = nominal = (NominalAttribute)attribute;
                if (i >= p - 1) continue;
                this.base[i + 1] = this.base[i] + nominal.size();
                continue;
            }
            throw new IllegalArgumentException("Non-nominal attribute: " + attribute);
        }
    }

    public int[] feature(double[] x) {
        if (x.length != this.attributes.length) {
            throw new IllegalArgumentException(String.format("Invalid feature vector size %d, expected %d", x.length, this.attributes.length));
        }
        int[] features = new int[this.attributes.length];
        for (int i = 0; i < features.length; ++i) {
            int f = (int)x[i];
            if (Math.floor(x[i]) != x[i] || f < 0 || f >= this.attributes[i].size()) {
                throw new IllegalArgumentException(String.format("Invalid value of attribute %s: %d", this.attributes[i].toString(), f));
            }
            features[i] = f + this.base[i];
        }
        return features;
    }
}

