/*
 * Decompiled with CFR 0.152.
 */
package smile.feature;

import smile.data.Attribute;
import smile.data.NominalAttribute;
import smile.data.NumericAttribute;
import smile.feature.FeatureGenerator;

public class OneHotEncoder
implements FeatureGenerator<double[]> {
    private Attribute[] attributes;
    private Attribute[] features;

    public OneHotEncoder(Attribute[] attributes) {
        this.attributes = attributes;
        int p = 0;
        for (Attribute attribute : attributes) {
            if (attribute instanceof NominalAttribute) {
                NominalAttribute nominal = (NominalAttribute)attribute;
                p += nominal.size();
                continue;
            }
            ++p;
        }
        this.features = new Attribute[p];
        int i = 0;
        for (int j = 0; j < attributes.length; ++j) {
            Attribute attribute = attributes[j];
            if (attribute instanceof NominalAttribute) {
                NominalAttribute nominal = (NominalAttribute)attribute;
                double weight = nominal.getWeight();
                String name = nominal.getName();
                String description = nominal.getDescription();
                int k = 0;
                while (k < nominal.size()) {
                    this.features[i] = new NumericAttribute(name + "_" + k, description, weight);
                    ++k;
                    ++i;
                }
                continue;
            }
            this.features[i++] = attribute;
        }
    }

    @Override
    public Attribute[] attributes() {
        return this.features;
    }

    @Override
    public double[] feature(double[] x) {
        if (x.length != this.attributes.length) {
            throw new IllegalArgumentException(String.format("Invalid vector size %d, expected %d", x.length, this.attributes.length));
        }
        double[] y = new double[this.features.length];
        int i = 0;
        for (int j = 0; j < this.attributes.length; ++j) {
            Attribute attribute = this.attributes[j];
            if (attribute instanceof NominalAttribute) {
                NominalAttribute nominal = (NominalAttribute)attribute;
                y[i + (int)x[j]] = 1.0;
                i += nominal.size();
                continue;
            }
            y[i++] = x[j];
        }
        return y;
    }
}

