/*
 * Decompiled with CFR 0.152.
 */
package smile.stat.hypothesis;

import smile.math.special.Gamma;

public class ChiSqTest {
    public final String method;
    public final double df;
    public final double chisq;
    public final double pvalue;
    public final double CramerV;

    public ChiSqTest(String method, double chisq2, double df, double pvalue) {
        this(method, chisq2, df, pvalue, Double.NaN);
    }

    public ChiSqTest(String method, double chisq2, double df, double pvalue, double CramerV) {
        this.method = method;
        this.chisq = chisq2;
        this.df = df;
        this.pvalue = pvalue;
        this.CramerV = CramerV;
    }

    public String toString() {
        if (Double.isNaN(this.CramerV)) {
            return String.format("%s Chi-squared Test(t = %.4f, df = %.3f, p-value = %G)", this.method, this.chisq, this.df, this.pvalue);
        }
        return String.format("%s Chi-squared Test(t = %.4f, df = %.3f, p-value = %G, Cramer's V = %.2f)", this.method, this.chisq, this.df, this.pvalue, this.CramerV);
    }

    public static ChiSqTest test(int[] bins, double[] prob) {
        return ChiSqTest.test(bins, prob, 1);
    }

    public static ChiSqTest test(int[] bins, double[] prob, int constraints) {
        int nbins = bins.length;
        int df = nbins - constraints;
        int n = 0;
        for (int bin : bins) {
            n += bin;
        }
        double chisq2 = 0.0;
        for (int j = 0; j < nbins; ++j) {
            if (prob[j] < 0.0 || prob[j] > 1.0 || prob[j] == 0.0 && bins[j] > 0) {
                throw new IllegalArgumentException("Bad expected number");
            }
            if (prob[j] == 0.0 && bins[j] == 0) {
                --df;
                continue;
            }
            double nj = (double)n * prob[j];
            double temp = (double)bins[j] - nj;
            chisq2 += temp * temp / nj;
        }
        double p = Gamma.regularizedUpperIncompleteGamma(0.5 * (double)df, 0.5 * chisq2);
        return new ChiSqTest("One Sample", chisq2, df, p);
    }

    public static ChiSqTest test(int[] bins1, int[] bins2) {
        return ChiSqTest.test(bins1, bins2, 1);
    }

    public static ChiSqTest test(int[] bins1, int[] bins2, int constraints) {
        if (bins1.length != bins2.length) {
            throw new IllegalArgumentException("Input vectors have different size");
        }
        int nbins = bins1.length;
        int df = nbins - constraints;
        double chisq2 = 0.0;
        for (int j = 0; j < nbins; ++j) {
            if (bins1[j] == 0 && bins2[j] == 0) {
                --df;
                continue;
            }
            double temp = bins1[j] - bins2[j];
            chisq2 += temp * temp / (double)(bins1[j] + bins2[j]);
        }
        double p = Gamma.regularizedUpperIncompleteGamma(0.5 * (double)df, 0.5 * chisq2);
        return new ChiSqTest("Two Sample", chisq2, df, p);
    }

    public static ChiSqTest test(int[][] table) {
        double TINY = 1.0E-16;
        int nrow = table.length;
        int ncol = table[0].length;
        boolean correct = false;
        if (nrow == 2 && ncol == 2) {
            correct = true;
        }
        double n = 0.0;
        int r = nrow;
        double[] ni = new double[nrow];
        for (int i = 0; i < nrow; ++i) {
            for (int j = 0; j < ncol; ++j) {
                int n2 = i;
                ni[n2] = ni[n2] + (double)table[i][j];
                n += (double)table[i][j];
            }
            if (ni[i] != 0.0) continue;
            --r;
        }
        int k = ncol;
        double[] nj = new double[ncol];
        for (int j = 0; j < ncol; ++j) {
            for (int[] row : table) {
                int n3 = j;
                nj[n3] = nj[n3] + (double)row[j];
            }
            if (nj[j] != 0.0) continue;
            --k;
        }
        int df = r * k - r - k + 1;
        double chisq2 = 0.0;
        for (int i = 0; i < nrow; ++i) {
            for (int j = 0; j < ncol; ++j) {
                double expctd = nj[j] * ni[i] / n;
                double temp = (double)table[i][j] - expctd;
                if (correct) {
                    temp = Math.abs(temp) - 0.5;
                }
                chisq2 += temp * temp / (expctd + 1.0E-16);
            }
        }
        double prob = Gamma.regularizedUpperIncompleteGamma(0.5 * (double)df, 0.5 * chisq2);
        int min = Math.min(r, k) - 1;
        double CramerV = Math.sqrt(chisq2 / (n * (double)min));
        return new ChiSqTest("Pearson's", chisq2, df, prob, CramerV);
    }
}

