/*
 * Decompiled with CFR 0.152.
 */
package smile.stat.distribution;

import smile.math.MathEx;
import smile.math.special.Gamma;
import smile.stat.distribution.AbstractDistribution;

public class WeibullDistribution
extends AbstractDistribution {
    private static final long serialVersionUID = 2L;
    public final double k;
    public final double lambda;
    private final double mean;
    private final double variance;
    private final double entropy;

    public WeibullDistribution(double k) {
        this(k, 1.0);
    }

    public WeibullDistribution(double k, double lambda) {
        if (k <= 0.0) {
            throw new IllegalArgumentException("Invalid shape: " + k);
        }
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("Invalid scale: " + lambda);
        }
        this.k = k;
        this.lambda = lambda;
        this.mean = lambda * Gamma.gamma(1.0 + 1.0 / k);
        this.variance = lambda * lambda * Gamma.gamma(1.0 + 2.0 / k) - this.mean * this.mean;
        this.entropy = 0.5772156649015329 * (1.0 - 1.0 / k) + Math.log(lambda / k) + 1.0;
    }

    @Override
    public int length() {
        return 2;
    }

    @Override
    public double mean() {
        return this.mean;
    }

    @Override
    public double variance() {
        return this.variance;
    }

    @Override
    public double entropy() {
        return this.entropy;
    }

    public String toString() {
        return String.format("Weibull Distribution(%.4f, %.4f)", this.k, this.lambda);
    }

    @Override
    public double rand() {
        double r = MathEx.random();
        return this.lambda * Math.pow(-Math.log(1.0 - r), 1.0 / this.k);
    }

    @Override
    public double p(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return this.k / this.lambda * Math.pow(x / this.lambda, this.k - 1.0) * Math.exp(-Math.pow(x / this.lambda, this.k));
    }

    @Override
    public double logp(double x) {
        if (x <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return Math.log(this.k / this.lambda) + (this.k - 1.0) * Math.log(x / this.lambda) - Math.pow(x / this.lambda, this.k);
    }

    @Override
    public double cdf(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return 1.0 - Math.exp(-Math.pow(x / this.lambda, this.k));
    }

    @Override
    public double quantile(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Invalid p: " + p);
        }
        return this.lambda * Math.pow(-Math.log(1.0 - p), 1.0 / this.k);
    }
}

