/*
 * Decompiled with CFR 0.152.
 */
package smile.neighbor.lsh;

import java.util.Objects;
import smile.neighbor.lsh.Hash;
import smile.neighbor.lsh.PrZ;

public class Probe
implements Comparable<Probe> {
    private final int[] range;
    int[] bucket;
    int last;
    double prob;

    public Probe(int[] range) {
        this.range = range;
        this.bucket = new int[range.length];
        this.last = 0;
    }

    protected Probe clone() {
        Probe p = new Probe(this.range);
        p.last = this.last;
        System.arraycopy(this.bucket, 0, p.bucket, 0, this.bucket.length);
        return p;
    }

    public boolean isShiftable() {
        return this.bucket[this.last] == 1 && this.last + 1 < this.bucket.length && this.range[this.last + 1] > 1;
    }

    public Probe shift() {
        Probe p = this.clone();
        p.bucket[this.last] = 0;
        ++p.last;
        p.bucket[this.last] = 1;
        return p;
    }

    public boolean isExpandable() {
        return this.last + 1 < this.bucket.length && this.range[this.last + 1] > 1;
    }

    public Probe expand() {
        Probe p = this.clone();
        ++p.last;
        p.bucket[this.last] = 1;
        return p;
    }

    public boolean isExtendable() {
        return this.bucket[this.last] + 1 < this.range[this.last];
    }

    public Probe extend() {
        Probe p = this.clone();
        int n = this.last;
        p.bucket[n] = p.bucket[n] + 1;
        return p;
    }

    @Override
    public int compareTo(Probe o) {
        return Double.compare(this.prob, o.prob);
    }

    public void setProb(PrZ[] pz) {
        this.prob = 1.0;
        for (int i = 0; i < this.bucket.length; ++i) {
            this.prob *= pz[i].prh[this.bucket[i]].pr;
        }
    }

    public int hash(Hash hash, PrZ[] pz) {
        long r = 0L;
        int[] c = hash.c;
        for (int i = 0; i < hash.k; ++i) {
            r += (long)(c[pz[i].m] * pz[i].prh[this.bucket[i]].u);
        }
        Objects.requireNonNull(hash);
        int h = (int)(r % Integer.MAX_VALUE);
        if (h < 0) {
            h += hash.P;
        }
        return h;
    }
}

