/*
 * Decompiled with CFR 0.152.
 */
package smile.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeMicroVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeNanoVector;
import org.apache.arrow.vector.TimeSecVector;
import org.apache.arrow.vector.TimeStampMicroVector;
import org.apache.arrow.vector.TimeStampMilliTZVector;
import org.apache.arrow.vector.TimeStampMilliVector;
import org.apache.arrow.vector.TimeStampNanoVector;
import org.apache.arrow.vector.TimeStampSecVector;
import org.apache.arrow.vector.TimeStampVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.UInt2Vector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.data.DataFrame;
import smile.data.type.ArrayType;
import smile.data.type.DataType;
import smile.data.type.DataTypes;
import smile.data.type.ObjectType;
import smile.data.type.StructField;
import smile.data.type.StructType;
import smile.data.vector.BaseVector;
import smile.data.vector.BooleanVector;
import smile.data.vector.ByteVector;
import smile.data.vector.CharVector;
import smile.data.vector.DoubleVector;
import smile.data.vector.FloatVector;
import smile.data.vector.LongVector;
import smile.data.vector.ShortVector;
import smile.data.vector.StringVector;
import smile.data.vector.Vector;
import smile.io.Input;

public class Arrow {
    private static final Logger logger = LoggerFactory.getLogger(Arrow.class);
    private static RootAllocator allocator;
    private final int batch;

    public Arrow() {
        this(1000000);
    }

    public Arrow(int batch) {
        if (batch <= 0) {
            throw new IllegalArgumentException("Invalid batch size: " + batch);
        }
        this.batch = batch;
    }

    public static void allocate(long limit) {
        if (limit <= 0L) {
            throw new IllegalArgumentException("Invalid RootAllocator limit: " + limit);
        }
        allocator = new RootAllocator(limit);
    }

    public DataFrame read(Path path) throws IOException {
        return this.read(path, Integer.MAX_VALUE);
    }

    public DataFrame read(Path path, int limit) throws IOException {
        return this.read(Files.newInputStream(path, new OpenOption[0]), limit);
    }

    public DataFrame read(String path) throws IOException, URISyntaxException {
        return this.read(path, Integer.MAX_VALUE);
    }

    public DataFrame read(String path, int limit) throws IOException, URISyntaxException {
        return this.read(Input.stream(path), limit);
    }

    public DataFrame read(InputStream input, int limit) throws IOException {
        if (allocator == null) {
            Arrow.allocate(Long.MAX_VALUE);
        }
        try (ArrowStreamReader reader = new ArrowStreamReader(input, (BufferAllocator)allocator);){
            Iterable fieldVectors;
            VectorSchemaRoot root = reader.getVectorSchemaRoot();
            ArrayList<DataFrame> frames = new ArrayList<DataFrame>();
            for (int size = 0; reader.loadNextBatch() && size < limit; size += frames.size()) {
                fieldVectors = root.getFieldVectors();
                logger.info("read {} rows and {} columns", (Object)root.getRowCount(), (Object)fieldVectors.size());
                BaseVector[] vectors = new BaseVector[fieldVectors.size()];
                block29: for (int j = 0; j < fieldVectors.size(); ++j) {
                    FieldVector fieldVector = (FieldVector)fieldVectors.get(j);
                    ArrowType type = fieldVector.getField().getType();
                    switch (type.getTypeID()) {
                        case Int: {
                            ArrowType.Int itype = (ArrowType.Int)type;
                            int bitWidth = itype.getBitWidth();
                            switch (bitWidth) {
                                case 8: {
                                    vectors[j] = this.readByteField(fieldVector);
                                    continue block29;
                                }
                                case 16: {
                                    if (itype.getIsSigned()) {
                                        vectors[j] = this.readShortField(fieldVector);
                                        continue block29;
                                    }
                                    vectors[j] = this.readCharField(fieldVector);
                                    continue block29;
                                }
                                case 32: {
                                    vectors[j] = this.readIntField(fieldVector);
                                    continue block29;
                                }
                                case 64: {
                                    vectors[j] = this.readLongField(fieldVector);
                                    continue block29;
                                }
                            }
                            throw new UnsupportedOperationException("Unsupported integer bit width: " + bitWidth);
                        }
                        case FloatingPoint: {
                            FloatingPointPrecision precision = ((ArrowType.FloatingPoint)type).getPrecision();
                            switch (precision) {
                                case DOUBLE: {
                                    vectors[j] = this.readDoubleField(fieldVector);
                                    continue block29;
                                }
                                case SINGLE: {
                                    vectors[j] = this.readFloatField(fieldVector);
                                    continue block29;
                                }
                                case HALF: {
                                    throw new UnsupportedOperationException("Unsupported float precision: " + precision);
                                }
                            }
                            continue block29;
                        }
                        case Decimal: {
                            vectors[j] = this.readDecimalField(fieldVector);
                            continue block29;
                        }
                        case Bool: {
                            vectors[j] = this.readBitField(fieldVector);
                            continue block29;
                        }
                        case Date: {
                            vectors[j] = this.readDateField(fieldVector);
                            continue block29;
                        }
                        case Time: {
                            vectors[j] = this.readTimeField(fieldVector);
                            continue block29;
                        }
                        case Timestamp: {
                            vectors[j] = this.readDateTimeField(fieldVector);
                            continue block29;
                        }
                        case Binary: 
                        case FixedSizeBinary: {
                            vectors[j] = this.readByteArrayField(fieldVector);
                            continue block29;
                        }
                        case Utf8: {
                            vectors[j] = this.readStringField(fieldVector);
                            continue block29;
                        }
                        default: {
                            throw new UnsupportedOperationException("Unsupported column type: " + fieldVector.getMinorType());
                        }
                    }
                }
                DataFrame frame = DataFrame.of(vectors);
                frames.add(frame);
            }
            if (frames.isEmpty()) {
                throw new IllegalStateException("No record batch");
            }
            if (frames.size() == 1) {
                fieldVectors = (DataFrame)frames.get(0);
                return fieldVectors;
            }
            DataFrame df = (DataFrame)frames.get(0);
            DataFrame dataFrame = df.union(frames.subList(1, frames.size()).toArray(new DataFrame[frames.size() - 1]));
            return dataFrame;
        }
    }

    public void write(DataFrame data, Path path) throws IOException {
        if (allocator == null) {
            Arrow.allocate(Long.MAX_VALUE);
        }
        Schema schema = this.toArrowSchema(data.schema());
        DictionaryProvider.MapDictionaryProvider provider = new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]);
        try (VectorSchemaRoot root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)allocator);
             OutputStream output = Files.newOutputStream(path, new OpenOption[0]);
             ArrowStreamWriter writer = new ArrowStreamWriter(root, (DictionaryProvider)provider, output);){
            writer.start();
            int size = data.size();
            for (int from = 0; from < size; from += this.batch) {
                int count = Math.min(this.batch, size - from);
                root.setRowCount(count);
                block32: for (Field field : root.getSchema().getFields()) {
                    FieldVector vector = root.getVector(field.getName());
                    DataType type = data.schema().field((String)field.getName()).type;
                    switch (type.id()) {
                        case Integer: {
                            this.writeIntField(data, vector, from, count);
                            continue block32;
                        }
                        case Long: {
                            this.writeLongField(data, vector, from, count);
                            continue block32;
                        }
                        case Double: {
                            this.writeDoubleField(data, vector, from, count);
                            continue block32;
                        }
                        case Float: {
                            this.writeFloatField(data, vector, from, count);
                            continue block32;
                        }
                        case Boolean: {
                            this.writeBooleanField(data, vector, from, count);
                            continue block32;
                        }
                        case Byte: {
                            this.writeByteField(data, vector, from, count);
                            continue block32;
                        }
                        case Short: {
                            this.writeShortField(data, vector, from, count);
                            continue block32;
                        }
                        case Char: {
                            this.writeCharField(data, vector, from, count);
                            continue block32;
                        }
                        case String: {
                            this.writeStringField(data, vector, from, count);
                            continue block32;
                        }
                        case Date: {
                            this.writeDateField(data, vector, from, count);
                            continue block32;
                        }
                        case Time: {
                            this.writeTimeField(data, vector, from, count);
                            continue block32;
                        }
                        case DateTime: {
                            this.writeDateTimeField(data, vector, from, count);
                            continue block32;
                        }
                        case Object: {
                            Class<?> clazz = ((ObjectType)type).getObjectClass();
                            if (clazz == Integer.class) {
                                this.writeIntObjectField(data, vector, from, count);
                                continue block32;
                            }
                            if (clazz == Long.class) {
                                this.writeLongObjectField(data, vector, from, count);
                                continue block32;
                            }
                            if (clazz == Double.class) {
                                this.writeDoubleObjectField(data, vector, from, count);
                                continue block32;
                            }
                            if (clazz == Float.class) {
                                this.writeFloatObjectField(data, vector, from, count);
                                continue block32;
                            }
                            if (clazz == Boolean.class) {
                                this.writeBooleanObjectField(data, vector, from, count);
                                continue block32;
                            }
                            if (clazz == Byte.class) {
                                this.writeByteObjectField(data, vector, from, count);
                                continue block32;
                            }
                            if (clazz == Short.class) {
                                this.writeShortObjectField(data, vector, from, count);
                                continue block32;
                            }
                            if (clazz == Character.class) {
                                this.writeCharObjectField(data, vector, from, count);
                                continue block32;
                            }
                            if (clazz == BigDecimal.class) {
                                this.writeDecimalField(data, vector, from, count);
                                continue block32;
                            }
                            if (clazz == String.class) {
                                this.writeStringField(data, vector, from, count);
                                continue block32;
                            }
                            if (clazz == LocalDate.class) {
                                this.writeDateField(data, vector, from, count);
                                continue block32;
                            }
                            if (clazz == LocalTime.class) {
                                this.writeTimeField(data, vector, from, count);
                                continue block32;
                            }
                            if (clazz == LocalDateTime.class) {
                                this.writeDateTimeField(data, vector, from, count);
                                continue block32;
                            }
                            throw new UnsupportedOperationException("Unsupported type: " + type);
                        }
                        case Array: {
                            DataType etype = ((ArrayType)type).getComponentType();
                            if (etype.id() == DataType.ID.Byte) {
                                this.writeByteArrayField(data, vector, from, count);
                                continue block32;
                            }
                            throw new UnsupportedOperationException("Unsupported type: " + type);
                        }
                    }
                    throw new UnsupportedOperationException("Unsupported type: " + type);
                }
                writer.writeBatch();
                logger.info("write {} rows", (Object)count);
            }
        }
    }

    private BaseVector readBitField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        BitVector vector = (BitVector)fieldVector;
        if (!fieldVector.getField().isNullable()) {
            boolean[] a = new boolean[count];
            for (int i = 0; i < count; ++i) {
                a[i] = vector.get(i) != 0;
            }
            return BooleanVector.of(fieldVector.getField().getName(), a);
        }
        Boolean[] a = new Boolean[count];
        for (int i = 0; i < count; ++i) {
            a[i] = vector.isNull(i) ? null : Boolean.valueOf(vector.get(i) != 0);
        }
        return Vector.of(fieldVector.getField().getName(), Boolean.class, a);
    }

    private BaseVector readByteField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        TinyIntVector vector = (TinyIntVector)fieldVector;
        if (!fieldVector.getField().isNullable()) {
            byte[] a = new byte[count];
            for (int i = 0; i < count; ++i) {
                a[i] = vector.get(i);
            }
            return ByteVector.of(fieldVector.getField().getName(), a);
        }
        Byte[] a = new Byte[count];
        for (int i = 0; i < count; ++i) {
            a[i] = vector.isNull(i) ? null : Byte.valueOf(vector.get(i));
        }
        return Vector.of(fieldVector.getField().getName(), Byte.class, a);
    }

    private BaseVector readCharField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        SmallIntVector vector = (SmallIntVector)fieldVector;
        if (!fieldVector.getField().isNullable()) {
            char[] a = new char[count];
            for (int i = 0; i < count; ++i) {
                a[i] = (char)vector.get(i);
            }
            return CharVector.of(fieldVector.getField().getName(), a);
        }
        Character[] a = new Character[count];
        for (int i = 0; i < count; ++i) {
            a[i] = vector.isNull(i) ? null : Character.valueOf((char)vector.get(i));
        }
        return Vector.of(fieldVector.getField().getName(), Character.class, a);
    }

    private BaseVector readShortField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        SmallIntVector vector = (SmallIntVector)fieldVector;
        if (!fieldVector.getField().isNullable()) {
            short[] a = new short[count];
            for (int i = 0; i < count; ++i) {
                a[i] = vector.get(i);
            }
            return ShortVector.of(fieldVector.getField().getName(), a);
        }
        Short[] a = new Short[count];
        for (int i = 0; i < count; ++i) {
            a[i] = vector.isNull(i) ? null : Short.valueOf(vector.get(i));
        }
        return Vector.of(fieldVector.getField().getName(), Short.class, a);
    }

    private BaseVector readIntField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        IntVector vector = (IntVector)fieldVector;
        if (!fieldVector.getField().isNullable()) {
            int[] a = new int[count];
            for (int i = 0; i < count; ++i) {
                a[i] = vector.get(i);
            }
            return smile.data.vector.IntVector.of(fieldVector.getField().getName(), a);
        }
        Integer[] a = new Integer[count];
        for (int i = 0; i < count; ++i) {
            a[i] = vector.isNull(i) ? null : Integer.valueOf(vector.get(i));
        }
        return Vector.of(fieldVector.getField().getName(), Integer.class, a);
    }

    private BaseVector readLongField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        BigIntVector vector = (BigIntVector)fieldVector;
        if (!fieldVector.getField().isNullable()) {
            long[] a = new long[count];
            for (int i = 0; i < count; ++i) {
                a[i] = vector.get(i);
            }
            return LongVector.of(fieldVector.getField().getName(), a);
        }
        Long[] a = new Long[count];
        for (int i = 0; i < count; ++i) {
            a[i] = vector.isNull(i) ? null : Long.valueOf(vector.get(i));
        }
        return Vector.of(fieldVector.getField().getName(), Long.class, a);
    }

    private BaseVector readFloatField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        Float4Vector vector = (Float4Vector)fieldVector;
        if (!fieldVector.getField().isNullable()) {
            float[] a = new float[count];
            for (int i = 0; i < count; ++i) {
                a[i] = vector.get(i);
            }
            return FloatVector.of(fieldVector.getField().getName(), a);
        }
        Float[] a = new Float[count];
        for (int i = 0; i < count; ++i) {
            a[i] = vector.isNull(i) ? null : Float.valueOf(vector.get(i));
        }
        return Vector.of(fieldVector.getField().getName(), Float.class, a);
    }

    private BaseVector readDoubleField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        Float8Vector vector = (Float8Vector)fieldVector;
        if (!fieldVector.getField().isNullable()) {
            double[] a = new double[count];
            for (int i = 0; i < count; ++i) {
                a[i] = vector.get(i);
            }
            return DoubleVector.of(fieldVector.getField().getName(), a);
        }
        Double[] a = new Double[count];
        for (int i = 0; i < count; ++i) {
            a[i] = vector.isNull(i) ? null : Double.valueOf(vector.get(i));
        }
        return Vector.of(fieldVector.getField().getName(), Double.class, a);
    }

    private BaseVector readDecimalField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        BigDecimal[] a = new BigDecimal[count];
        DecimalVector vector = (DecimalVector)fieldVector;
        for (int i = 0; i < count; ++i) {
            a[i] = vector.isNull(i) ? null : vector.getObject(i);
        }
        return Vector.of(fieldVector.getField().getName(), DataTypes.DecimalType, a);
    }

    private BaseVector readDateField(FieldVector fieldVector) {
        LocalDate[] a;
        block3: {
            ZoneOffset zone;
            int count;
            block2: {
                count = fieldVector.getValueCount();
                a = new LocalDate[count];
                zone = OffsetDateTime.now().getOffset();
                if (!(fieldVector instanceof DateDayVector)) break block2;
                DateDayVector vector = (DateDayVector)fieldVector;
                for (int i = 0; i < count; ++i) {
                    a[i] = vector.isNull(i) ? null : LocalDate.ofEpochDay(vector.get(i));
                }
                break block3;
            }
            if (!(fieldVector instanceof DateMilliVector)) break block3;
            DateMilliVector vector = (DateMilliVector)fieldVector;
            for (int i = 0; i < count; ++i) {
                a[i] = vector.isNull(i) ? null : LocalDateTime.ofInstant(Instant.ofEpochMilli(vector.get(i)), zone).toLocalDate();
            }
        }
        return Vector.of(fieldVector.getField().getName(), DataTypes.DateType, a);
    }

    private BaseVector readTimeField(FieldVector fieldVector) {
        LocalTime[] a;
        block5: {
            int count;
            block7: {
                block6: {
                    block4: {
                        count = fieldVector.getValueCount();
                        a = new LocalTime[count];
                        if (!(fieldVector instanceof TimeNanoVector)) break block4;
                        TimeNanoVector vector = (TimeNanoVector)fieldVector;
                        for (int i = 0; i < count; ++i) {
                            a[i] = vector.isNull(i) ? null : LocalTime.ofNanoOfDay(vector.get(i));
                        }
                        break block5;
                    }
                    if (!(fieldVector instanceof TimeMilliVector)) break block6;
                    TimeMilliVector vector = (TimeMilliVector)fieldVector;
                    for (int i = 0; i < count; ++i) {
                        a[i] = vector.isNull(i) ? null : LocalTime.ofNanoOfDay(vector.get(i) * 1000000);
                    }
                    break block5;
                }
                if (!(fieldVector instanceof TimeMicroVector)) break block7;
                TimeMicroVector vector = (TimeMicroVector)fieldVector;
                for (int i = 0; i < count; ++i) {
                    a[i] = vector.isNull(i) ? null : LocalTime.ofNanoOfDay(vector.get(i) * 1000L);
                }
                break block5;
            }
            if (!(fieldVector instanceof TimeSecVector)) break block5;
            TimeSecVector vector = (TimeSecVector)fieldVector;
            for (int i = 0; i < count; ++i) {
                a[i] = vector.isNull(i) ? null : LocalTime.ofSecondOfDay(vector.get(i));
            }
        }
        return Vector.of(fieldVector.getField().getName(), DataTypes.TimeType, a);
    }

    private BaseVector readDateTimeField(FieldVector fieldVector) {
        LocalDateTime[] a;
        block5: {
            ZoneOffset zone;
            TimeStampVector vector;
            int count;
            block7: {
                block6: {
                    block4: {
                        count = fieldVector.getValueCount();
                        a = new LocalDateTime[count];
                        vector = (TimeStampVector)fieldVector;
                        String timezone = ((ArrowType.Timestamp)fieldVector.getField().getType()).getTimezone();
                        ZoneOffset zoneOffset = zone = timezone == null ? OffsetDateTime.now().getOffset() : ZoneOffset.of(timezone);
                        if (!(fieldVector instanceof TimeStampMilliVector)) break block4;
                        for (int i = 0; i < count; ++i) {
                            a[i] = vector.isNull(i) ? null : LocalDateTime.ofInstant(Instant.ofEpochMilli(vector.get(i)), zone);
                        }
                        break block5;
                    }
                    if (!(fieldVector instanceof TimeStampNanoVector)) break block6;
                    for (int i = 0; i < count; ++i) {
                        a[i] = vector.isNull(i) ? null : LocalDateTime.ofInstant(Instant.ofEpochMilli(vector.get(i) / 1000000L), zone);
                    }
                    break block5;
                }
                if (!(fieldVector instanceof TimeStampMicroVector)) break block7;
                for (int i = 0; i < count; ++i) {
                    a[i] = vector.isNull(i) ? null : LocalDateTime.ofInstant(Instant.ofEpochMilli(vector.get(i) / 1000L), zone);
                }
                break block5;
            }
            if (!(fieldVector instanceof TimeStampSecVector)) break block5;
            for (int i = 0; i < count; ++i) {
                a[i] = vector.isNull(i) ? null : LocalDateTime.ofEpochSecond(vector.get(i), 0, zone);
            }
        }
        return Vector.of(fieldVector.getField().getName(), DataTypes.DateTimeType, a);
    }

    private BaseVector readByteArrayField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        byte[][] a = new byte[count][];
        if (fieldVector instanceof VarBinaryVector) {
            VarBinaryVector vector = (VarBinaryVector)fieldVector;
            for (int i = 0; i < count; ++i) {
                a[i] = (byte[])(vector.isNull(i) ? null : vector.get(i));
            }
        } else if (fieldVector instanceof FixedSizeBinaryVector) {
            FixedSizeBinaryVector vector = (FixedSizeBinaryVector)fieldVector;
            for (int i = 0; i < count; ++i) {
                a[i] = (byte[])(vector.isNull(i) ? null : vector.get(i));
            }
        } else {
            throw new UnsupportedOperationException("Unsupported binary vector: " + fieldVector);
        }
        return Vector.of(fieldVector.getField().getName(), DataTypes.ByteArrayType, a);
    }

    private BaseVector readStringField(FieldVector fieldVector) {
        int count = fieldVector.getValueCount();
        VarCharVector vector = (VarCharVector)fieldVector;
        String[] a = new String[count];
        for (int i = 0; i < count; ++i) {
            a[i] = vector.isNull(i) ? null : new String(vector.get(i));
        }
        return Vector.of(fieldVector.getField().getName(), DataTypes.StringType, a);
    }

    private void writeIntField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        IntVector vector = (IntVector)fieldVector;
        smile.data.vector.IntVector column = df.intVector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            vector.set(i, column.getInt(j));
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeIntObjectField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        IntVector vector = (IntVector)fieldVector;
        Vector column = df.vector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            Integer x = (Integer)column.get(i);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.intValue());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeBooleanField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        BitVector vector = (BitVector)fieldVector;
        BooleanVector column = df.booleanVector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            vector.set(i, column.getInt(j));
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeBooleanObjectField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        BitVector vector = (BitVector)fieldVector;
        Vector column = df.vector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            Boolean x = (Boolean)column.get(i);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x != false ? 1 : 0);
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeCharField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        UInt2Vector vector = (UInt2Vector)fieldVector;
        CharVector column = df.charVector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            vector.set(i, column.getChar(j));
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeCharObjectField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        UInt2Vector vector = (UInt2Vector)fieldVector;
        Vector column = df.vector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            Character x = (Character)column.get(i);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.charValue());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeByteField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        TinyIntVector vector = (TinyIntVector)fieldVector;
        ByteVector column = df.byteVector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            vector.set(i, column.getByte(j));
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeByteObjectField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        TinyIntVector vector = (TinyIntVector)fieldVector;
        Vector column = df.vector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            Byte x = (Byte)column.get(i);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.byteValue());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeShortField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        SmallIntVector vector = (SmallIntVector)fieldVector;
        ShortVector column = df.shortVector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            vector.set(i, column.getShort(j));
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeShortObjectField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        SmallIntVector vector = (SmallIntVector)fieldVector;
        Vector column = df.vector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            Short x = (Short)column.get(i);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.shortValue());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeLongField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        BigIntVector vector = (BigIntVector)fieldVector;
        LongVector column = df.longVector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            vector.set(i, column.getLong(j));
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeLongObjectField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        BigIntVector vector = (BigIntVector)fieldVector;
        Vector column = df.vector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            Long x = (Long)column.get(i);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.longValue());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeFloatField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Float4Vector vector = (Float4Vector)fieldVector;
        FloatVector column = df.floatVector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            vector.set(i, column.getFloat(j));
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeFloatObjectField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Float4Vector vector = (Float4Vector)fieldVector;
        Vector column = df.vector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            Float x = (Float)column.get(i);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.floatValue());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeDoubleField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Float8Vector vector = (Float8Vector)fieldVector;
        DoubleVector column = df.doubleVector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            vector.set(i, column.getDouble(j));
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeDoubleObjectField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        Float8Vector vector = (Float8Vector)fieldVector;
        Vector column = df.vector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            Double x = (Double)column.get(i);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.doubleValue());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeStringField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        VarCharVector vector = (VarCharVector)fieldVector;
        StringVector column = df.stringVector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            String x = (String)column.get(j);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.getBytes(StandardCharsets.UTF_8));
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeDecimalField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        DecimalVector vector = (DecimalVector)fieldVector;
        Vector column = df.vector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            BigDecimal x = (BigDecimal)column.get(j);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x);
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeDateField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        DateDayVector vector = (DateDayVector)fieldVector;
        Vector column = df.vector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            LocalDate x = (LocalDate)column.get(j);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, (int)x.toEpochDay());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeTimeField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        TimeNanoVector vector = (TimeNanoVector)fieldVector;
        Vector column = df.vector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            LocalTime x = (LocalTime)column.get(j);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.toNanoOfDay());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeDateTimeField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        TimeStampMilliTZVector vector = (TimeStampMilliTZVector)fieldVector;
        Vector column = df.vector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            LocalDateTime x = (LocalDateTime)column.get(j);
            if (x == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, x.toInstant(OffsetDateTime.now().getOffset()).toEpochMilli());
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private void writeByteArrayField(DataFrame df, FieldVector fieldVector, int from, int count) {
        fieldVector.setInitialCapacity(count);
        fieldVector.allocateNew();
        VarBinaryVector vector = (VarBinaryVector)fieldVector;
        Vector column = df.vector(fieldVector.getField().getName());
        int i = 0;
        int j = from;
        while (i < count) {
            byte[] bytes = (byte[])column.get(j);
            if (bytes == null) {
                vector.setNull(i);
            } else {
                vector.setIndexDefined(i);
                vector.setSafe(i, bytes);
            }
            ++i;
            ++j;
        }
        fieldVector.setValueCount(count);
    }

    private Schema toArrowSchema(StructType schema) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (StructField field : schema.fields()) {
            fields.add(this.toArrowField(field));
        }
        return new Schema(fields, null);
    }

    private StructType toSmileSchema(Schema schema) {
        ArrayList<StructField> fields = new ArrayList<StructField>();
        for (Field field : schema.getFields()) {
            fields.add(this.toSmileField(field));
        }
        return DataTypes.struct(fields);
    }

    private Field toArrowField(StructField field) {
        switch (field.type.id()) {
            case Integer: {
                return new Field(field.name, new FieldType(false, (ArrowType)new ArrowType.Int(32, true), null), null);
            }
            case Long: {
                return new Field(field.name, new FieldType(false, (ArrowType)new ArrowType.Int(64, true), null), null);
            }
            case Double: {
                return new Field(field.name, new FieldType(false, (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE), null), null);
            }
            case Float: {
                return new Field(field.name, new FieldType(false, (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE), null), null);
            }
            case Boolean: {
                return new Field(field.name, new FieldType(false, (ArrowType)new ArrowType.Bool(), null), null);
            }
            case Byte: {
                return new Field(field.name, new FieldType(false, (ArrowType)new ArrowType.Int(8, true), null), null);
            }
            case Short: {
                return new Field(field.name, new FieldType(false, (ArrowType)new ArrowType.Int(16, true), null), null);
            }
            case Char: {
                return new Field(field.name, new FieldType(false, (ArrowType)new ArrowType.Int(16, false), null), null);
            }
            case Decimal: {
                return new Field(field.name, FieldType.nullable((ArrowType)new ArrowType.Decimal(28, 10, 128)), null);
            }
            case String: {
                return new Field(field.name, FieldType.nullable((ArrowType)new ArrowType.Utf8()), null);
            }
            case Date: {
                return new Field(field.name, FieldType.nullable((ArrowType)new ArrowType.Date(DateUnit.DAY)), null);
            }
            case Time: {
                return new Field(field.name, FieldType.nullable((ArrowType)new ArrowType.Time(TimeUnit.MILLISECOND, 32)), null);
            }
            case DateTime: {
                return new Field(field.name, FieldType.nullable((ArrowType)new ArrowType.Timestamp(TimeUnit.MILLISECOND, ZoneOffset.UTC.getId())), null);
            }
            case Object: {
                Class<?> clazz = ((ObjectType)field.type).getObjectClass();
                if (clazz == Integer.class) {
                    return new Field(field.name, FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), null);
                }
                if (clazz == Long.class) {
                    return new Field(field.name, FieldType.nullable((ArrowType)new ArrowType.Int(64, true)), null);
                }
                if (clazz == Double.class) {
                    return new Field(field.name, FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE)), null);
                }
                if (clazz == Float.class) {
                    return new Field(field.name, FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE)), null);
                }
                if (clazz == Boolean.class) {
                    return new Field(field.name, FieldType.nullable((ArrowType)new ArrowType.Bool()), null);
                }
                if (clazz == Byte.class) {
                    return new Field(field.name, FieldType.nullable((ArrowType)new ArrowType.Int(8, true)), null);
                }
                if (clazz == Short.class) {
                    return new Field(field.name, FieldType.nullable((ArrowType)new ArrowType.Int(16, true)), null);
                }
                if (clazz != Character.class) break;
                return new Field(field.name, FieldType.nullable((ArrowType)new ArrowType.Int(16, false)), null);
            }
            case Array: {
                DataType etype = ((ArrayType)field.type).getComponentType();
                switch (etype.id()) {
                    case Integer: {
                        return new Field(field.name, new FieldType(false, (ArrowType)new ArrowType.List(), null), Collections.singletonList(new Field(null, new FieldType(false, (ArrowType)new ArrowType.Int(32, true), null), null)));
                    }
                    case Long: {
                        return new Field(field.name, new FieldType(false, (ArrowType)new ArrowType.List(), null), Collections.singletonList(new Field(null, new FieldType(false, (ArrowType)new ArrowType.Int(64, true), null), null)));
                    }
                    case Double: {
                        return new Field(field.name, new FieldType(false, (ArrowType)new ArrowType.List(), null), Collections.singletonList(new Field(null, new FieldType(false, (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE), null), null)));
                    }
                    case Float: {
                        return new Field(field.name, new FieldType(false, (ArrowType)new ArrowType.List(), null), Collections.singletonList(new Field(null, new FieldType(false, (ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE), null), null)));
                    }
                    case Boolean: {
                        return new Field(field.name, new FieldType(false, (ArrowType)new ArrowType.List(), null), Collections.singletonList(new Field(null, new FieldType(false, (ArrowType)new ArrowType.Bool(), null), null)));
                    }
                    case Byte: {
                        return new Field(field.name, FieldType.nullable((ArrowType)new ArrowType.Binary()), null);
                    }
                    case Short: {
                        return new Field(field.name, new FieldType(false, (ArrowType)new ArrowType.List(), null), Collections.singletonList(new Field(null, new FieldType(false, (ArrowType)new ArrowType.Int(16, true), null), null)));
                    }
                    case Char: {
                        return new Field(field.name, FieldType.nullable((ArrowType)new ArrowType.Utf8()), null);
                    }
                }
                break;
            }
            case Struct: {
                StructType children = (StructType)field.type;
                return new Field(field.name, new FieldType(false, (ArrowType)new ArrowType.Struct(), null), Arrays.stream(children.fields()).map(this::toArrowField).collect(Collectors.toList()));
            }
        }
        throw new UnsupportedOperationException("Unsupported smile to arrow type conversion: " + field.type);
    }

    private StructField toSmileField(Field field) {
        String name = field.getName();
        ArrowType type = field.getType();
        boolean nullable = field.isNullable();
        switch (type.getTypeID()) {
            case Int: {
                ArrowType.Int itype = (ArrowType.Int)type;
                int bitWidth = itype.getBitWidth();
                switch (bitWidth) {
                    case 8: {
                        return new StructField(name, nullable ? DataTypes.ByteObjectType : DataTypes.ByteType);
                    }
                    case 16: {
                        if (itype.getIsSigned()) {
                            return new StructField(name, nullable ? DataTypes.ShortObjectType : DataTypes.ShortType);
                        }
                        return new StructField(name, nullable ? DataTypes.CharObjectType : DataTypes.CharType);
                    }
                    case 32: {
                        return new StructField(name, nullable ? DataTypes.IntegerObjectType : DataTypes.IntegerType);
                    }
                    case 64: {
                        return new StructField(name, nullable ? DataTypes.LongObjectType : DataTypes.LongType);
                    }
                }
                throw new UnsupportedOperationException("Unsupported integer bit width: " + bitWidth);
            }
            case FloatingPoint: {
                FloatingPointPrecision precision = ((ArrowType.FloatingPoint)type).getPrecision();
                switch (precision) {
                    case DOUBLE: {
                        return new StructField(name, nullable ? DataTypes.DoubleObjectType : DataTypes.DoubleType);
                    }
                    case SINGLE: {
                        return new StructField(name, nullable ? DataTypes.FloatObjectType : DataTypes.FloatType);
                    }
                    case HALF: {
                        throw new UnsupportedOperationException("Unsupported float precision: " + precision);
                    }
                }
            }
            case Bool: {
                return new StructField(name, nullable ? DataTypes.BooleanObjectType : DataTypes.BooleanType);
            }
            case Decimal: {
                return new StructField(name, DataTypes.DecimalType);
            }
            case Utf8: {
                return new StructField(name, DataTypes.StringType);
            }
            case Date: {
                return new StructField(name, DataTypes.DateType);
            }
            case Time: {
                return new StructField(name, DataTypes.TimeType);
            }
            case Timestamp: {
                return new StructField(name, DataTypes.DateTimeType);
            }
            case Binary: 
            case FixedSizeBinary: {
                return new StructField(name, DataTypes.ByteArrayType);
            }
            case List: 
            case FixedSizeList: {
                List child = field.getChildren();
                if (child.size() != 1) {
                    throw new IllegalStateException(String.format("List type has %d child fields.", child.size()));
                }
                return new StructField(name, DataTypes.array(this.toSmileField((Field)((Field)child.get((int)0))).type));
            }
            case Struct: {
                List<StructField> children = field.getChildren().stream().map(this::toSmileField).collect(Collectors.toList());
                return new StructField(name, DataTypes.struct(children));
            }
        }
        throw new UnsupportedOperationException("Unsupported arrow to smile type conversion: " + type);
    }
}

