/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import smile.data.measure.CategoricalMeasure;
import smile.data.measure.NominalScale;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.vector.BaseVector;
import smile.data.vector.ByteVectorImpl;
import smile.data.vector.IntVectorImpl;
import smile.data.vector.ShortVectorImpl;
import smile.data.vector.StringVector;
import smile.data.vector.Vector;
import smile.data.vector.VectorImpl;

class StringVectorImpl
extends VectorImpl<String>
implements StringVector {
    public StringVectorImpl(String name, String[] vector) {
        super(name, String.class, vector);
    }

    public StringVectorImpl(StructField field, String[] vector) {
        super(field.name, field.type, vector);
        if (field.measure != null) {
            throw new IllegalArgumentException(String.format("Invalid measure %s for %s", field.measure, this.type()));
        }
    }

    @Override
    public StringVector get(int ... index) {
        String[] v = new String[index.length];
        for (int i = 0; i < index.length; ++i) {
            v[i] = (String)this.get(index[i]);
        }
        return new StringVectorImpl(this.field(), v);
    }

    @Override
    public Vector<LocalDate> toDate() {
        return this.toDate(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    @Override
    public Vector<LocalDate> toDate(DateTimeFormatter format) {
        LocalDate[] dates = (LocalDate[])this.stream().map(format::parse).toArray(LocalDate[]::new);
        return new VectorImpl<LocalDate>(this.name(), DataTypes.DateType, dates);
    }

    @Override
    public Vector<LocalTime> toTime() {
        return this.toTime(DateTimeFormatter.ISO_LOCAL_TIME);
    }

    @Override
    public Vector<LocalTime> toTime(DateTimeFormatter format) {
        LocalTime[] dates = (LocalTime[])this.stream().map(format::parse).toArray(LocalTime[]::new);
        return new VectorImpl<LocalTime>(this.name(), DataTypes.TimeType, dates);
    }

    @Override
    public Vector<LocalDateTime> toDateTime() {
        return this.toDateTime(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    @Override
    public Vector<LocalDateTime> toDateTime(DateTimeFormatter format) {
        LocalDateTime[] dates = (LocalDateTime[])this.stream().map(format::parse).toArray(LocalDateTime[]::new);
        return new VectorImpl<LocalDateTime>(this.name(), DataTypes.DateTimeType, dates);
    }

    @Override
    public NominalScale nominal() {
        List<String> levels = this.distinct();
        Collections.sort(levels);
        return new NominalScale(levels);
    }

    @Override
    public BaseVector factorize(CategoricalMeasure scale) {
        switch (scale.type().id()) {
            case Byte: {
                byte[] data = new byte[this.size()];
                for (int i = 0; i < data.length; ++i) {
                    String s = (String)this.get(i);
                    data[i] = s == null ? -1 : (int)scale.valueOf(s).byteValue();
                }
                return new ByteVectorImpl(new StructField(this.name(), DataTypes.ByteType, scale), data);
            }
            case Short: {
                short[] data = new short[this.size()];
                for (int i = 0; i < data.length; ++i) {
                    String s = (String)this.get(i);
                    data[i] = s == null ? -1 : (int)scale.valueOf(s).shortValue();
                }
                return new ShortVectorImpl(new StructField(this.name(), DataTypes.ShortType, scale), data);
            }
            case Integer: {
                int[] data = new int[this.size()];
                for (int i = 0; i < data.length; ++i) {
                    String s = (String)this.get(i);
                    data[i] = s == null ? -1 : scale.valueOf(s).intValue();
                }
                return new IntVectorImpl(new StructField(this.name(), DataTypes.IntegerType, scale), data);
            }
        }
        throw new UnsupportedOperationException("Unsupported data type for nominal measure: " + scale.type());
    }
}

