/*
 * Decompiled with CFR 0.152.
 */
package net.lucode.hackware.magicindicator;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import java.util.ArrayList;
import java.util.List;
import net.lucode.hackware.magicindicator.MagicIndicator;
import net.lucode.hackware.magicindicator.buildins.commonnavigator.model.PositionData;

@TargetApi(value=11)
public class FragmentContainerHelper {
    private List<MagicIndicator> mMagicIndicators = new ArrayList<MagicIndicator>();
    private ValueAnimator mScrollAnimator;
    private int mLastSelectedIndex;
    private int mDuration = 150;
    private Interpolator mInterpolator = new AccelerateDecelerateInterpolator();
    private Animator.AnimatorListener mAnimatorListener = new AnimatorListenerAdapter(){

        public void onAnimationEnd(Animator animation) {
            FragmentContainerHelper.this.dispatchPageScrollStateChanged(0);
            FragmentContainerHelper.this.mScrollAnimator = null;
        }
    };
    private ValueAnimator.AnimatorUpdateListener mAnimatorUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            float positionOffsetSum = ((Float)animation.getAnimatedValue()).floatValue();
            int position = (int)positionOffsetSum;
            float positionOffset = positionOffsetSum - (float)position;
            if (positionOffsetSum < 0.0f) {
                --position;
                positionOffset = 1.0f + positionOffset;
            }
            FragmentContainerHelper.this.dispatchPageScrolled(position, positionOffset, 0);
        }
    };

    public FragmentContainerHelper() {
    }

    public FragmentContainerHelper(MagicIndicator magicIndicator) {
        this.mMagicIndicators.add(magicIndicator);
    }

    public static PositionData getImitativePositionData(List<PositionData> positionDataList, int index) {
        PositionData referenceData;
        int offset;
        if (index >= 0 && index <= positionDataList.size() - 1) {
            return positionDataList.get(index);
        }
        PositionData result = new PositionData();
        if (index < 0) {
            offset = index;
            referenceData = positionDataList.get(0);
        } else {
            offset = index - positionDataList.size() + 1;
            referenceData = positionDataList.get(positionDataList.size() - 1);
        }
        result.mLeft = referenceData.mLeft + offset * referenceData.width();
        result.mTop = referenceData.mTop;
        result.mRight = referenceData.mRight + offset * referenceData.width();
        result.mBottom = referenceData.mBottom;
        result.mContentLeft = referenceData.mContentLeft + offset * referenceData.width();
        result.mContentTop = referenceData.mContentTop;
        result.mContentRight = referenceData.mContentRight + offset * referenceData.width();
        result.mContentBottom = referenceData.mContentBottom;
        return result;
    }

    public void handlePageSelected(int selectedIndex) {
        this.handlePageSelected(selectedIndex, true);
    }

    public void handlePageSelected(int selectedIndex, boolean smooth) {
        if (this.mLastSelectedIndex == selectedIndex) {
            return;
        }
        if (smooth) {
            if (this.mScrollAnimator == null || !this.mScrollAnimator.isRunning()) {
                this.dispatchPageScrollStateChanged(2);
            }
            this.dispatchPageSelected(selectedIndex);
            float currentPositionOffsetSum = this.mLastSelectedIndex;
            if (this.mScrollAnimator != null) {
                currentPositionOffsetSum = ((Float)this.mScrollAnimator.getAnimatedValue()).floatValue();
                this.mScrollAnimator.cancel();
                this.mScrollAnimator = null;
            }
            this.mScrollAnimator = new ValueAnimator();
            this.mScrollAnimator.setFloatValues(new float[]{currentPositionOffsetSum, selectedIndex});
            this.mScrollAnimator.addUpdateListener(this.mAnimatorUpdateListener);
            this.mScrollAnimator.addListener(this.mAnimatorListener);
            this.mScrollAnimator.setInterpolator((TimeInterpolator)this.mInterpolator);
            this.mScrollAnimator.setDuration((long)this.mDuration);
            this.mScrollAnimator.start();
        } else {
            this.dispatchPageSelected(selectedIndex);
            if (this.mScrollAnimator != null && this.mScrollAnimator.isRunning()) {
                this.dispatchPageScrolled(this.mLastSelectedIndex, 0.0f, 0);
            }
            this.dispatchPageScrollStateChanged(0);
            this.dispatchPageScrolled(selectedIndex, 0.0f, 0);
        }
        this.mLastSelectedIndex = selectedIndex;
    }

    public void setDuration(int duration) {
        this.mDuration = duration;
    }

    public void setInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator == null ? new AccelerateDecelerateInterpolator() : interpolator;
    }

    public void attachMagicIndicator(MagicIndicator magicIndicator) {
        this.mMagicIndicators.add(magicIndicator);
    }

    private void dispatchPageSelected(int pageIndex) {
        for (MagicIndicator magicIndicator : this.mMagicIndicators) {
            magicIndicator.onPageSelected(pageIndex);
        }
    }

    private void dispatchPageScrollStateChanged(int state) {
        for (MagicIndicator magicIndicator : this.mMagicIndicators) {
            magicIndicator.onPageScrollStateChanged(state);
        }
    }

    private void dispatchPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        for (MagicIndicator magicIndicator : this.mMagicIndicators) {
            magicIndicator.onPageScrolled(position, positionOffset, positionOffsetPixels);
        }
    }
}

