/*
 * Decompiled with CFR 0.152.
 */
package org.osjava;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringsToTypes {
    private static final Set<String> trueValues = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private static final Set<String> falseValues = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private static final int OLD_ENUM_STYLE = 25;
    private static final List<SimpleDateFormat> dateTimeFormats;
    private static final List<SimpleDateFormat> dateFormats;
    private static final List<SimpleDateFormat> timeFormats;

    public static boolean toBoolean(String value) {
        if (trueValues.contains(value)) {
            return true;
        }
        if (falseValues.contains(value)) {
            return false;
        }
        throw StringsToTypes.newRuntimeException(value, Boolean.TYPE);
    }

    @Nullable
    private static Field findOldStyleEnumField(@NotNull Class<?> clazz, String name) {
        Field[] fields;
        if (clazz == null) {
            StringsToTypes.$$$reportNull$$$0(0);
        }
        for (Field field : fields = clazz.getFields()) {
            if (!clazz.equals(field.getType()) || !field.getName().equalsIgnoreCase(name.trim()) || (field.getModifiers() & 0x19) != 25) continue;
            return field;
        }
        return null;
    }

    public static Object getOldStyleEnumFieldValue(Class<?> toWhat, String value) {
        Object obj;
        try {
            Field field = StringsToTypes.findOldStyleEnumField(toWhat, value);
            obj = field == null ? ObjectUtils.NULL : field.get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to access class: " + toWhat, e);
        }
        return obj;
    }

    @NotNull
    public static Object callConstructor(@NotNull Class<?> toWhat, String value) {
        Object obj;
        if (toWhat == null) {
            StringsToTypes.$$$reportNull$$$0(1);
        }
        try {
            Constructor<?> constructor = toWhat.getConstructor(String.class);
            obj = constructor.newInstance(value);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to find (String) constructor on class: " + toWhat, e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to instantiate class: " + toWhat, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to access class: " + toWhat, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Unable to invoke (String) constructor on class: " + toWhat, e);
        }
        if (obj == null) {
            StringsToTypes.$$$reportNull$$$0(2);
        }
        return obj;
    }

    @NotNull
    public static Object toEnum(@NotNull Class<?> toWhat, String value) {
        Enum e;
        ?[] enumConstants;
        if (toWhat == null) {
            StringsToTypes.$$$reportNull$$$0(3);
        }
        Enum obj = null;
        boolean valid = false;
        for (Object oe : enumConstants = toWhat.getEnumConstants()) {
            e = (Enum)oe;
            if (!e.name().equals(value)) continue;
            obj = e;
            valid = true;
        }
        for (Object oe : enumConstants) {
            e = (Enum)oe;
            if (!e.name().equalsIgnoreCase(value)) continue;
            obj = e;
            valid = true;
        }
        if (!valid) {
            throw StringsToTypes.newRuntimeException(value, toWhat);
        }
        Enum enum_ = obj;
        if (enum_ == null) {
            StringsToTypes.$$$reportNull$$$0(4);
        }
        return enum_;
    }

    @NotNull
    public static Object toTimestamp(String value) {
        Timestamp obj = null;
        boolean valid = false;
        for (SimpleDateFormat sdf : dateTimeFormats) {
            try {
                obj = new Timestamp(sdf.parse(value).getTime());
                valid = true;
                break;
            }
            catch (ParseException parseException) {
            }
        }
        if (!valid) {
            throw StringsToTypes.newRuntimeException(value, Timestamp.class);
        }
        Timestamp timestamp = obj;
        if (timestamp == null) {
            StringsToTypes.$$$reportNull$$$0(5);
        }
        return timestamp;
    }

    @NotNull
    public static Object toTime(String value) {
        Time obj = null;
        boolean valid = false;
        for (SimpleDateFormat sdf : timeFormats) {
            try {
                obj = new Time(sdf.parse(value).getTime());
                valid = true;
                break;
            }
            catch (ParseException parseException) {
            }
        }
        if (!valid) {
            throw StringsToTypes.newRuntimeException(value, Time.class);
        }
        Time time = obj;
        if (time == null) {
            StringsToTypes.$$$reportNull$$$0(6);
        }
        return time;
    }

    @NotNull
    public static Object toSqlDate(String value) {
        Date obj = null;
        boolean valid = false;
        for (SimpleDateFormat sdf : dateFormats) {
            try {
                obj = new Date(sdf.parse(value).getTime());
                valid = true;
                break;
            }
            catch (ParseException parseException) {
            }
        }
        if (!valid) {
            throw StringsToTypes.newRuntimeException(value, Date.class);
        }
        Date date = obj;
        if (date == null) {
            StringsToTypes.$$$reportNull$$$0(7);
        }
        return date;
    }

    public static Object toDate(String value) {
        java.util.Date obj = null;
        boolean valid = false;
        for (SimpleDateFormat sdf : dateTimeFormats) {
            try {
                obj = sdf.parse(value);
                valid = true;
                break;
            }
            catch (ParseException parseException) {
            }
        }
        if (!valid) {
            throw StringsToTypes.newRuntimeException(value, java.util.Date.class);
        }
        return obj;
    }

    @NotNull
    private static RuntimeException newRuntimeException(String value, Class<?> toWhat) {
        return new RuntimeException(String.format("The value, '%s' could not be converted to a '%s'", value, toWhat.getName()));
    }

    public static char toCharacter(@NotNull String value) {
        if (value == null) {
            StringsToTypes.$$$reportNull$$$0(8);
        }
        return !value.isEmpty() ? value.charAt(0) : (char)'\u0000';
    }

    static {
        Collections.addAll(trueValues, "true", "t", "yes", "y", "on", "1", "x", "-1");
        Collections.addAll(falseValues, "false", "f", "no", "n", "off", "0", "");
        dateTimeFormats = new ArrayList<SimpleDateFormat>();
        Collections.addAll(dateTimeFormats, new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm"), new SimpleDateFormat("yyyy-MM-dd"));
        for (SimpleDateFormat sdf : dateTimeFormats) {
            sdf.setLenient(false);
        }
        dateFormats = new ArrayList<SimpleDateFormat>();
        Collections.addAll(dateFormats, new SimpleDateFormat("yyyy-MM-dd"));
        for (SimpleDateFormat sdf : dateFormats) {
            sdf.setLenient(false);
        }
        timeFormats = new ArrayList<SimpleDateFormat>();
        Collections.addAll(timeFormats, new SimpleDateFormat("HH:mm:ss.SSSZ"), new SimpleDateFormat("HH:mm:ss.SSSXXX"), new SimpleDateFormat("HH:mm:ss"), new SimpleDateFormat("HH:mm"));
        for (SimpleDateFormat sdf : timeFormats) {
            sdf.setLenient(false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toWhat";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/osjava/StringsToTypes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/osjava/StringsToTypes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "callConstructor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toEnum";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toTimestamp";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toTime";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toSqlDate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findOldStyleEnumField";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "callConstructor";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toEnum";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "toCharacter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

