/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.os.IBinder;
import android.os.RemoteException;
import com.github.gzuliyujiang.oaid.IGetter;
import com.github.gzuliyujiang.oaid.OAIDException;
import com.github.gzuliyujiang.oaid.OAIDLog;
import com.github.gzuliyujiang.oaid.impl.OAIDService;
import com.github.gzuliyujiang.oaid.impl.OppoImpl;
import repeackage.com.oplus.stdid.IStdID;

public class OppoExtImpl
extends OppoImpl {
    private static final String ACTION = "action.com.oplus.stdid.ID_SERVICE";
    private static final String PACKAGE_NAME = "com.coloros.mcs";
    private static final String CLASS_NAME = "com.oplus.stdid.IdentifyService";
    private final Context context;

    public OppoExtImpl(Context context) {
        super(context);
        this.context = context;
    }

    @Override
    public boolean supported() {
        if (this.context == null) {
            return false;
        }
        try {
            PackageInfo pi = this.context.getPackageManager().getPackageInfo(PACKAGE_NAME, 0);
            return pi != null;
        }
        catch (Exception e) {
            OAIDLog.print(e);
            return false;
        }
    }

    @Override
    public void doGet(IGetter getter) {
        if (this.context == null || getter == null) {
            return;
        }
        Intent intent = new Intent(ACTION);
        intent.setComponent(new ComponentName(PACKAGE_NAME, CLASS_NAME));
        OAIDService.bind(this.context, intent, getter, new OAIDService.RemoteCaller(){

            @Override
            public String callRemoteInterface(IBinder service) throws OAIDException, RemoteException {
                try {
                    return OppoExtImpl.this.realGetOUID(service);
                }
                catch (RemoteException | OAIDException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new OAIDException(e);
                }
            }
        });
    }

    @Override
    protected String getSerId(IBinder service, String pkgName, String sign) throws RemoteException, OAIDException {
        IStdID anInterface = IStdID.Stub.asInterface(service);
        if (anInterface == null) {
            throw new OAIDException("IStdID is null");
        }
        return anInterface.getSerID(pkgName, sign, "OUID");
    }
}

