/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.os.Looper;
import com.github.gzuliyujiang.oaid.IGetter;
import com.github.gzuliyujiang.oaid.IOAID;
import com.github.gzuliyujiang.oaid.OAIDException;
import com.github.gzuliyujiang.oaid.OAIDLog;
import com.huawei.hms.ads.identifier.AdvertisingIdClient;
import java.io.IOException;
import java.util.concurrent.Executors;

class HuaweiImpl
implements IOAID {
    private final Context context;
    private final Handler uiHandler = new Handler(Looper.getMainLooper());

    public HuaweiImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supported() {
        if (this.context == null) {
            return false;
        }
        boolean ret = false;
        try {
            PackageManager pm = this.context.getPackageManager();
            ret = pm.getPackageInfo("com.huawei.hwid", 0) != null ? true : (pm.getPackageInfo("com.huawei.hwid.tv", 0) != null ? true : pm.getPackageInfo("com.huawei.hms", 0) != null);
        }
        catch (Exception e) {
            OAIDLog.print(e);
        }
        return ret;
    }

    @Override
    public void doGet(final IGetter getter) {
        if (this.context == null || getter == null) {
            return;
        }
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                HuaweiImpl.this.runOnSubThread(getter);
            }
        });
    }

    private void runOnSubThread(IGetter getter) {
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.context);
            if (info == null) {
                this.postOnMainThread(getter, new OAIDException("Advertising identifier info is null"));
                return;
            }
            if (info.isLimitAdTrackingEnabled()) {
                this.postOnMainThread(getter, new OAIDException("User has disabled advertising identifier"));
                return;
            }
            this.postOnMainThread(getter, info.getId());
        }
        catch (IOException e) {
            OAIDLog.print(e);
            this.postOnMainThread(getter, new OAIDException(e));
        }
    }

    private void postOnMainThread(final IGetter getter, final String oaid) {
        this.uiHandler.post(new Runnable(){

            @Override
            public void run() {
                getter.onOAIDGetComplete(oaid);
            }
        });
    }

    private void postOnMainThread(final IGetter getter, final OAIDException e) {
        this.uiHandler.post(new Runnable(){

            @Override
            public void run() {
                getter.onOAIDGetError(e);
            }
        });
    }
}

