/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.os.IBinder;
import android.os.RemoteException;
import com.github.gzuliyujiang.oaid.IGetter;
import com.github.gzuliyujiang.oaid.IOAID;
import com.github.gzuliyujiang.oaid.OAIDException;
import com.github.gzuliyujiang.oaid.OAIDLog;
import com.github.gzuliyujiang.oaid.impl.OAIDService;
import repeackage.com.bun.lib.MsaIdInterface;

class MsaImpl
implements IOAID {
    private final Context context;

    public MsaImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supported() {
        if (this.context == null) {
            return false;
        }
        try {
            PackageInfo pi = this.context.getPackageManager().getPackageInfo("com.mdid.msa", 0);
            return pi != null;
        }
        catch (Exception e) {
            OAIDLog.print(e);
            return false;
        }
    }

    @Override
    public void doGet(IGetter getter) {
        if (this.context == null || getter == null) {
            return;
        }
        this.startMsaKlService();
        Intent intent = new Intent("com.bun.msa.action.bindto.service");
        intent.setClassName("com.mdid.msa", "com.mdid.msa.service.MsaIdService");
        intent.putExtra("com.bun.msa.param.pkgname", this.context.getPackageName());
        OAIDService.bind(this.context, intent, getter, new OAIDService.RemoteCaller(){

            @Override
            public String callRemoteInterface(IBinder service) throws OAIDException, RemoteException {
                MsaIdInterface anInterface = MsaIdInterface.Stub.asInterface(service);
                if (anInterface == null) {
                    throw new OAIDException("MsaIdInterface is null");
                }
                if (!anInterface.isSupported()) {
                    throw new OAIDException("MsaIdInterface#isSupported return false");
                }
                return anInterface.getOAID();
            }
        });
    }

    private void startMsaKlService() {
        try {
            Intent intent = new Intent("com.bun.msa.action.start.service");
            intent.setClassName("com.mdid.msa", "com.mdid.msa.service.MsaKlService");
            intent.putExtra("com.bun.msa.param.pkgname", this.context.getPackageName());
            if (Build.VERSION.SDK_INT < 26) {
                this.context.startService(intent);
            } else {
                this.context.startForegroundService(intent);
            }
        }
        catch (Exception e) {
            OAIDLog.print(e);
        }
    }
}

