/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.content.Context;
import android.content.pm.PackageManager;
import com.github.gzuliyujiang.oaid.IGetter;
import com.github.gzuliyujiang.oaid.IOAID;
import com.github.gzuliyujiang.oaid.OAIDException;
import com.github.gzuliyujiang.oaid.OAIDLog;
import com.huawei.hms.ads.identifier.AdvertisingIdClient;
import java.io.IOException;

class HuaweiImpl
implements IOAID {
    private final Context context;

    public HuaweiImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supported() {
        if (this.context == null) {
            return false;
        }
        boolean ret = false;
        try {
            PackageManager pm = this.context.getPackageManager();
            ret = pm.getPackageInfo("com.huawei.hwid", 0) != null ? true : (pm.getPackageInfo("com.huawei.hwid.tv", 0) != null ? true : pm.getPackageInfo("com.huawei.hms", 0) != null);
        }
        catch (Exception e) {
            OAIDLog.print(e);
        }
        return ret;
    }

    @Override
    public void doGet(IGetter getter) {
        if (this.context == null || getter == null) {
            return;
        }
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.context);
            if (info == null) {
                getter.onOAIDGetError(new OAIDException("Advertising identifier info is null"));
                return;
            }
            if (info.isLimitAdTrackingEnabled()) {
                getter.onOAIDGetError(new OAIDException("User has disabled advertising identifier"));
                return;
            }
            getter.onOAIDGetComplete(info.getId());
        }
        catch (IOException e) {
            OAIDLog.print(e);
            getter.onOAIDGetError(e);
        }
    }
}

