/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.app.KeyguardManager;
import android.content.Context;
import com.github.gzuliyujiang.oaid.IGetter;
import com.github.gzuliyujiang.oaid.IOAID;
import com.github.gzuliyujiang.oaid.OAIDException;
import com.github.gzuliyujiang.oaid.OAIDLog;
import java.util.Objects;

public class CooseaImpl
implements IOAID {
    private final Context context;
    private final KeyguardManager keyguardManager;

    public CooseaImpl(Context context) {
        this.context = context;
        this.keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
    }

    @Override
    public boolean supported() {
        if (this.context == null) {
            return false;
        }
        if (this.keyguardManager == null) {
            return false;
        }
        try {
            Object obj = this.keyguardManager.getClass().getDeclaredMethod("isSupported", new Class[0]).invoke((Object)this.keyguardManager, new Object[0]);
            return (Boolean)Objects.requireNonNull(obj);
        }
        catch (Exception e) {
            OAIDLog.print(e);
            return false;
        }
    }

    @Override
    public void doGet(IGetter getter) {
        if (this.context == null || getter == null) {
            return;
        }
        if (this.keyguardManager == null) {
            getter.onOAIDGetError(new OAIDException("KeyguardManager not found"));
            return;
        }
        try {
            Object obj = this.keyguardManager.getClass().getDeclaredMethod("obtainOaid", new Class[0]).invoke((Object)this.keyguardManager, new Object[0]);
            if (obj == null) {
                throw new OAIDException("OAID obtain failed");
            }
            String oaid = obj.toString();
            OAIDLog.print("OAID obtain success: " + oaid);
            getter.onOAIDGetComplete(oaid);
        }
        catch (Exception e) {
            OAIDLog.print(e);
        }
    }
}

