/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.os.IBinder;
import android.os.RemoteException;
import com.github.gzuliyujiang.oaid.IGetter;
import com.github.gzuliyujiang.oaid.IOAID;
import com.github.gzuliyujiang.oaid.OAIDException;
import com.github.gzuliyujiang.oaid.OAIDLog;
import com.github.gzuliyujiang.oaid.impl.OAIDService;
import repeackage.com.qiku.id.IOAIDInterface;
import repeackage.com.qiku.id.QikuIdmanager;

public class QikuImpl
implements IOAID {
    private final Context context;
    private boolean mUseQikuId = true;

    public QikuImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supported() {
        if (this.context == null) {
            return false;
        }
        try {
            PackageInfo pi = this.context.getPackageManager().getPackageInfo("com.qiku.id", 0);
            if (pi != null) {
                return true;
            }
            this.mUseQikuId = false;
            return new QikuIdmanager().isSupported();
        }
        catch (Exception e) {
            OAIDLog.print(e);
            return false;
        }
    }

    @Override
    public void doGet(IGetter getter) {
        if (this.context == null || getter == null) {
            return;
        }
        if (this.mUseQikuId) {
            Intent intent = new Intent("qiku.service.action.id");
            intent.setPackage("com.qiku.id");
            OAIDService.bind(this.context, intent, getter, new OAIDService.RemoteCaller(){

                @Override
                public String callRemoteInterface(IBinder service) throws OAIDException, RemoteException {
                    IOAIDInterface anInterface = IOAIDInterface.Stub.asInterface(service);
                    if (anInterface == null) {
                        throw new OAIDException("IOAIDInterface is null");
                    }
                    return anInterface.getOAID();
                }
            });
        } else {
            try {
                String oaid = new QikuIdmanager().getOAID();
                if (oaid == null || oaid.length() == 0) {
                    throw new OAIDException("OAID/AAID acquire failed");
                }
                getter.onOAIDGetComplete(oaid);
            }
            catch (Exception e) {
                getter.onOAIDGetError(e);
            }
        }
    }
}

