/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid;

import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import com.github.gzuliyujiang.oaid.DeviceID;
import com.github.gzuliyujiang.oaid.IGetter;
import com.github.gzuliyujiang.oaid.IRegisterCallback;

public final class DeviceIdentifier {
    private static volatile boolean registered = false;
    private static volatile String clientId = null;
    private static volatile String imei = null;
    private static volatile String oaid = null;
    private static volatile String androidId = null;
    private static volatile String widevineId = null;
    private static volatile String pseudoId = null;
    private static volatile String guid = null;

    private DeviceIdentifier() {
    }

    public static void register(Application application) {
        DeviceIdentifier.register(application, null);
    }

    public static void register(Application application, boolean tryWidevine) {
        DeviceIdentifier.register(application, tryWidevine, null);
    }

    public static void register(Application application, IRegisterCallback callback) {
        DeviceIdentifier.register(application, false, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(Application application, boolean tryWidevine, IRegisterCallback callback) {
        if (registered || application == null) {
            return;
        }
        Class<DeviceIdentifier> clazz = DeviceIdentifier.class;
        synchronized (DeviceIdentifier.class) {
            if (!registered) {
                DeviceID.register(application, tryWidevine, callback);
                registered = true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static String getClientId() {
        return DeviceIdentifier.getClientId(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static String getClientId(boolean returnRaw) {
        if (TextUtils.isEmpty((CharSequence)clientId)) {
            Class<DeviceIdentifier> clazz = DeviceIdentifier.class;
            // MONITORENTER : com.github.gzuliyujiang.oaid.DeviceIdentifier.class
            if (TextUtils.isEmpty((CharSequence)clientId)) {
                clientId = returnRaw ? DeviceID.getClientId() : DeviceID.getClientIdMD5();
            }
            // MONITOREXIT : clazz
        }
        if (clientId != null) return clientId;
        clientId = "";
        return clientId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static String getIMEI(Context context) {
        if (imei == null) {
            Class<DeviceIdentifier> clazz = DeviceIdentifier.class;
            // MONITORENTER : com.github.gzuliyujiang.oaid.DeviceIdentifier.class
            if (imei == null) {
                imei = DeviceID.getUniqueID(context);
            }
            // MONITOREXIT : clazz
        }
        if (imei != null) return imei;
        imei = "";
        return imei;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static String getOAID(Context context) {
        if (TextUtils.isEmpty((CharSequence)oaid)) {
            Class<DeviceIdentifier> clazz = DeviceIdentifier.class;
            // MONITORENTER : com.github.gzuliyujiang.oaid.DeviceIdentifier.class
            if (TextUtils.isEmpty((CharSequence)oaid) && ((oaid = DeviceID.getOAID()) == null || oaid.length() == 0)) {
                DeviceID.getOAID(context, new IGetter(){

                    @Override
                    public void onOAIDGetComplete(String result) {
                        oaid = result;
                    }

                    @Override
                    public void onOAIDGetError(Exception error) {
                        oaid = "";
                    }
                });
            }
            // MONITOREXIT : clazz
        }
        if (oaid != null) return oaid;
        oaid = "";
        return oaid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static String getAndroidID(Context context) {
        if (androidId == null) {
            Class<DeviceIdentifier> clazz = DeviceIdentifier.class;
            // MONITORENTER : com.github.gzuliyujiang.oaid.DeviceIdentifier.class
            if (androidId == null) {
                androidId = DeviceID.getAndroidID(context);
            }
            // MONITOREXIT : clazz
        }
        if (androidId != null) return androidId;
        androidId = "";
        return androidId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Deprecated
    public static String getWidevineID() {
        if (widevineId == null) {
            Class<DeviceIdentifier> clazz = DeviceIdentifier.class;
            // MONITORENTER : com.github.gzuliyujiang.oaid.DeviceIdentifier.class
            if (widevineId == null) {
                widevineId = DeviceID.getWidevineID();
            }
            // MONITOREXIT : clazz
        }
        if (widevineId != null) return widevineId;
        widevineId = "";
        return widevineId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static String getPseudoID() {
        if (pseudoId == null) {
            Class<DeviceIdentifier> clazz = DeviceIdentifier.class;
            // MONITORENTER : com.github.gzuliyujiang.oaid.DeviceIdentifier.class
            if (pseudoId == null) {
                pseudoId = DeviceID.getPseudoID();
            }
            // MONITOREXIT : clazz
        }
        if (pseudoId != null) return pseudoId;
        pseudoId = "";
        return pseudoId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static String getGUID(Context context) {
        if (guid == null) {
            Class<DeviceIdentifier> clazz = DeviceIdentifier.class;
            // MONITORENTER : com.github.gzuliyujiang.oaid.DeviceIdentifier.class
            if (guid == null) {
                guid = DeviceID.getGUID(context);
            }
            // MONITOREXIT : clazz
        }
        if (guid != null) return guid;
        guid = "";
        return guid;
    }
}

