/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.content.ContentProviderClient;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import com.github.gzuliyujiang.oaid.IGetter;
import com.github.gzuliyujiang.oaid.IOAID;
import com.github.gzuliyujiang.oaid.OAIDException;
import com.github.gzuliyujiang.oaid.OAIDLog;

class NubiaImpl
implements IOAID {
    private final Context context;

    public NubiaImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supported() {
        return Build.VERSION.SDK_INT >= 29;
    }

    @Override
    public void doGet(IGetter getter) {
        if (this.context == null || getter == null) {
            return;
        }
        if (!this.supported()) {
            String message = "Only supports Android 10.0 and above for Nubia";
            OAIDLog.print(message);
            getter.onOAIDGetError(new OAIDException(message));
            return;
        }
        String oaid = null;
        try {
            Uri uri = Uri.parse((String)"content://cn.nubia.identity/identity");
            ContentProviderClient client = this.context.getContentResolver().acquireContentProviderClient(uri);
            if (client == null) {
                return;
            }
            Bundle bundle = client.call("getOAID", null, null);
            if (Build.VERSION.SDK_INT >= 24) {
                client.close();
            } else {
                client.release();
            }
            if (bundle == null) {
                throw new OAIDException("OAID query failed: bundle is null");
            }
            if (bundle.getInt("code", -1) == 0) {
                oaid = bundle.getString("id");
            }
            if (oaid == null || oaid.length() == 0) {
                throw new OAIDException("OAID query failed: " + bundle.getString("message"));
            }
            OAIDLog.print("OAID query success: " + oaid);
            getter.onOAIDGetComplete(oaid);
        }
        catch (Exception e) {
            OAIDLog.print(e);
            getter.onOAIDGetError(e);
        }
    }
}

