/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.IBinder;
import android.os.RemoteException;
import android.provider.Settings;
import android.text.TextUtils;
import com.github.gzuliyujiang.oaid.IGetter;
import com.github.gzuliyujiang.oaid.IOAID;
import com.github.gzuliyujiang.oaid.OAIDException;
import com.github.gzuliyujiang.oaid.OAIDLog;
import com.github.gzuliyujiang.oaid.impl.OAIDService;
import repeackage.com.uodis.opendevice.aidl.OpenDeviceIdentifierService;

class HuaweiImpl
implements IOAID {
    private final Context context;
    private String packageName;

    public HuaweiImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supported() {
        if (this.context == null) {
            return false;
        }
        boolean ret = false;
        try {
            PackageManager pm = this.context.getPackageManager();
            if (pm.getPackageInfo("com.huawei.hwid", 0) != null) {
                this.packageName = "com.huawei.hwid";
                ret = true;
            } else if (pm.getPackageInfo("com.huawei.hwid.tv", 0) != null) {
                this.packageName = "com.huawei.hwid.tv";
                ret = true;
            } else {
                this.packageName = "com.huawei.hms";
                ret = pm.getPackageInfo(this.packageName, 0) != null;
            }
        }
        catch (Exception e) {
            OAIDLog.print(e);
        }
        return ret;
    }

    @Override
    public void doGet(IGetter getter) {
        if (this.context == null || getter == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            try {
                String oaid = Settings.Global.getString((ContentResolver)this.context.getContentResolver(), (String)"pps_oaid");
                if (!TextUtils.isEmpty((CharSequence)oaid)) {
                    OAIDLog.print("Get oaid from global settings: " + oaid);
                    getter.onOAIDGetComplete(oaid);
                    return;
                }
            }
            catch (Exception e) {
                OAIDLog.print(e);
            }
        }
        if (TextUtils.isEmpty((CharSequence)this.packageName) && !this.supported()) {
            getter.onOAIDGetError(new OAIDException("Huawei Advertising ID not available"));
            return;
        }
        Intent intent = new Intent("com.uodis.opendevice.OPENIDS_SERVICE");
        intent.setPackage(this.packageName);
        OAIDService.bind(this.context, intent, getter, new OAIDService.RemoteCaller(){

            @Override
            public String callRemoteInterface(IBinder service) throws OAIDException, RemoteException {
                OpenDeviceIdentifierService anInterface = OpenDeviceIdentifierService.Stub.asInterface(service);
                if (anInterface.isOaidTrackLimited()) {
                    throw new OAIDException("User has disabled advertising identifier");
                }
                return anInterface.getOaid();
            }
        });
    }
}

