/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.os.IBinder;
import android.os.RemoteException;
import com.github.gzuliyujiang.oaid.IGetter;
import com.github.gzuliyujiang.oaid.IOAID;
import com.github.gzuliyujiang.oaid.OAIDException;
import com.github.gzuliyujiang.oaid.OAIDLog;
import com.github.gzuliyujiang.oaid.impl.OAIDService;
import repeackage.com.google.android.gms.ads.identifier.internal.IAdvertisingIdService;

class GmsImpl
implements IOAID {
    private final Context context;

    public GmsImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supported() {
        if (this.context == null) {
            return false;
        }
        try {
            PackageInfo pi = this.context.getPackageManager().getPackageInfo("com.android.vending", 0);
            return pi != null;
        }
        catch (Exception e) {
            OAIDLog.print(e);
            return false;
        }
    }

    @Override
    public void doGet(IGetter getter) {
        if (this.context == null || getter == null) {
            return;
        }
        Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
        intent.setPackage("com.google.android.gms");
        OAIDService.bind(this.context, intent, getter, new OAIDService.RemoteCaller(){

            @Override
            public String callRemoteInterface(IBinder service) throws OAIDException, RemoteException {
                IAdvertisingIdService anInterface = IAdvertisingIdService.Stub.asInterface(service);
                if (anInterface.isLimitAdTrackingEnabled(true)) {
                    OAIDLog.print("User has disabled advertising identifier");
                }
                return anInterface.getId();
            }
        });
    }
}

