/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.os.IBinder;
import android.os.RemoteException;
import com.github.gzuliyujiang.oaid.IGetter;
import com.github.gzuliyujiang.oaid.IOAID;
import com.github.gzuliyujiang.oaid.OAIDException;
import com.github.gzuliyujiang.oaid.OAIDLog;
import com.github.gzuliyujiang.oaid.impl.OAIDService;
import repeackage.com.asus.msa.SupplementaryDID.IDidAidlInterface;

class AsusImpl
implements IOAID {
    private final Context context;

    public AsusImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supported() {
        if (this.context == null) {
            return false;
        }
        try {
            PackageInfo pi = this.context.getPackageManager().getPackageInfo("com.asus.msa.SupplementaryDID", 0);
            return pi != null;
        }
        catch (Exception e) {
            OAIDLog.print(e);
            return false;
        }
    }

    @Override
    public void doGet(IGetter getter) {
        if (this.context == null || getter == null) {
            return;
        }
        Intent intent = new Intent("com.asus.msa.action.ACCESS_DID");
        String pkg = "com.asus.msa.SupplementaryDID";
        ComponentName componentName = new ComponentName(pkg, pkg + ".SupplementaryDIDService");
        intent.setComponent(componentName);
        OAIDService.bind(this.context, intent, getter, new OAIDService.RemoteCaller(){

            @Override
            public String callRemoteInterface(IBinder service) throws OAIDException, RemoteException {
                IDidAidlInterface anInterface = IDidAidlInterface.Stub.asInterface(service);
                if (anInterface == null) {
                    throw new OAIDException("IDidAidlInterface is null");
                }
                if (!anInterface.isSupport()) {
                    throw new OAIDException("IDidAidlInterface#isSupport return false");
                }
                return anInterface.getOAID();
            }
        });
    }
}

