/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.os.IBinder;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import com.github.gzuliyujiang.oaid.IGetter;
import com.github.gzuliyujiang.oaid.IOAID;
import com.github.gzuliyujiang.oaid.OAIDException;
import com.github.gzuliyujiang.oaid.OAIDLog;
import com.github.gzuliyujiang.oaid.impl.OAIDService;
import repeackage.com.samsung.android.deviceidservice.IDeviceIdService;

class SamsungImpl
implements IOAID {
    private final Context context;

    public SamsungImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supported() {
        try {
            PackageInfo pi = this.context.getPackageManager().getPackageInfo("com.samsung.android.deviceidservice", 0);
            return pi != null;
        }
        catch (Exception e) {
            OAIDLog.print(e);
            return false;
        }
    }

    @Override
    public void doGet(@NonNull IGetter getter) {
        Intent intent = new Intent();
        String pkg = "com.samsung.android.deviceidservice";
        intent.setClassName(pkg, pkg + ".DeviceIdService");
        OAIDService.bind(this.context, intent, getter, new OAIDService.RemoteCaller(){

            @Override
            public String callRemoteInterface(IBinder service) throws OAIDException, RemoteException {
                IDeviceIdService anInterface = IDeviceIdService.Stub.asInterface(service);
                if (anInterface == null) {
                    throw new OAIDException("IDeviceIdService is null");
                }
                return anInterface.getOAID();
            }
        });
    }
}

