/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.IBinder;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import com.github.gzuliyujiang.oaid.IGetter;
import com.github.gzuliyujiang.oaid.IOAID;
import com.github.gzuliyujiang.oaid.OAIDException;
import com.github.gzuliyujiang.oaid.OAIDLog;
import com.github.gzuliyujiang.oaid.impl.OAIDService;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import repeackage.com.heytap.openid.IOpenID;

class OppoImpl
implements IOAID {
    private final Context context;
    private String sign;

    public OppoImpl(Context context) {
        this.context = context instanceof Application ? context : context.getApplicationContext();
    }

    @Override
    public boolean supported() {
        try {
            PackageInfo pi = this.context.getPackageManager().getPackageInfo("com.heytap.openid", 0);
            return pi != null;
        }
        catch (Exception e) {
            OAIDLog.print(e);
            return false;
        }
    }

    @Override
    public void doGet(@NonNull IGetter getter) {
        Intent intent = new Intent("action.com.heytap.openid.OPEN_ID_SERVICE");
        String pkg = "com.heytap.openid";
        intent.setComponent(new ComponentName(pkg, pkg + ".IdentifyService"));
        OAIDService.bind(this.context, intent, getter, new OAIDService.RemoteCaller(){

            @Override
            public String callRemoteInterface(IBinder service) throws OAIDException, RemoteException {
                try {
                    return OppoImpl.this.realGetOUID(service);
                }
                catch (RemoteException | OAIDException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new OAIDException(e);
                }
            }
        });
    }

    @SuppressLint(value={"PackageManagerGetSignatures"})
    private String realGetOUID(IBinder service) throws PackageManager.NameNotFoundException, NoSuchAlgorithmException, RemoteException, OAIDException {
        String pkgName = this.context.getPackageName();
        if (this.sign == null) {
            Signature[] signatures = this.context.getPackageManager().getPackageInfo((String)pkgName, (int)64).signatures;
            byte[] byteArray = signatures[0].toByteArray();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            byte[] digest = messageDigest.digest(byteArray);
            StringBuilder sb = new StringBuilder();
            for (byte b : digest) {
                sb.append(Integer.toHexString(b & 0xFF | 0x100).substring(1, 3));
            }
            this.sign = sb.toString();
            return this.getSerId(service, pkgName, this.sign);
        }
        return this.getSerId(service, pkgName, this.sign);
    }

    private String getSerId(IBinder service, String pkgName, String sign) throws RemoteException, OAIDException {
        IOpenID anInterface = IOpenID.Stub.asInterface(service);
        if (anInterface == null) {
            throw new OAIDException("IOpenID is null");
        }
        return anInterface.getSerID(pkgName, sign, "OUID");
    }
}

