/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import com.github.gzuliyujiang.oaid.IGetter;
import com.github.gzuliyujiang.oaid.OAIDException;
import com.github.gzuliyujiang.oaid.OAIDLog;

class OAIDService
implements ServiceConnection {
    private final Context context;
    private final IGetter getter;
    private final RemoteCaller caller;

    public static void bind(Context context, Intent intent, IGetter getter, RemoteCaller caller) {
        new OAIDService(context, getter, caller).bind(intent);
    }

    private OAIDService(Context context, IGetter getter, RemoteCaller caller) {
        this.context = context instanceof Application ? context : context.getApplicationContext();
        this.getter = getter;
        this.caller = caller;
    }

    private void bind(Intent intent) {
        try {
            boolean ret = this.context.bindService(intent, (ServiceConnection)this, 1);
            if (!ret) {
                throw new OAIDException("Service binding failed");
            }
            OAIDLog.print("Service has been bound: " + intent);
        }
        catch (Exception e) {
            this.getter.onOAIDGetError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServiceConnected(ComponentName name, IBinder service) {
        OAIDLog.print("Service has been connected: " + name.getClassName());
        try {
            String oaid = this.caller.callRemoteInterface(service);
            if (oaid == null || oaid.length() == 0) {
                throw new OAIDException("OAID/AAID acquire failed");
            }
            OAIDLog.print("OAID/AAID acquire success: " + oaid);
            this.getter.onOAIDGetComplete(oaid);
        }
        catch (Exception e) {
            OAIDLog.print(e);
            this.getter.onOAIDGetError(e);
        }
        finally {
            try {
                this.context.unbindService((ServiceConnection)this);
                OAIDLog.print("Service has been unbound: " + name.getClassName());
            }
            catch (Exception e) {
                OAIDLog.print(e);
            }
        }
    }

    public void onServiceDisconnected(ComponentName name) {
        OAIDLog.print("Service has been disconnected: " + name.getClassName());
    }

    @FunctionalInterface
    public static interface RemoteCaller {
        @Nullable
        public String callRemoteInterface(IBinder var1) throws OAIDException, RemoteException;
    }
}

