/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import androidx.annotation.Nullable;
import com.github.gzuliyujiang.oaid.IGetter;
import com.github.gzuliyujiang.oaid.OAIDLog;

class OAIDService
implements ServiceConnection {
    private final Context context;
    private final IGetter getter;
    private final RemoteRunner runner;

    public static void bind(Context context, Intent intent, IGetter getter, RemoteRunner runner) {
        new OAIDService(context, intent, getter, runner);
    }

    private OAIDService(Context context, Intent intent, IGetter getter, RemoteRunner runner) {
        this.context = context instanceof Application ? context : context.getApplicationContext();
        this.getter = getter;
        this.runner = runner;
        try {
            boolean ret = context.bindService(intent, (ServiceConnection)this, 1);
            if (!ret) {
                throw new RuntimeException("Service binding failed");
            }
            OAIDLog.print("Service has been bound: " + intent);
        }
        catch (Throwable e) {
            getter.onOAIDGetError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServiceConnected(ComponentName name, IBinder service) {
        OAIDLog.print("Service has been connected: " + name.getClassName());
        try {
            String oaid = this.runner.runRemoteInterface(service);
            if (oaid == null || oaid.length() == 0) {
                throw new RuntimeException("OAID/AAID acquire failed");
            }
            OAIDLog.print("OAID/AAID acquire success: " + oaid);
            this.getter.onOAIDGetComplete(oaid);
        }
        catch (Throwable e) {
            OAIDLog.print(e);
            this.getter.onOAIDGetError(e);
        }
        finally {
            try {
                this.context.unbindService((ServiceConnection)this);
                OAIDLog.print("Service has been unbound: " + name.getClassName());
            }
            catch (Throwable e) {
                OAIDLog.print(e);
            }
        }
    }

    public void onServiceDisconnected(ComponentName name) {
        OAIDLog.print("Service has been disconnected: " + name.getClassName());
    }

    public static interface RemoteRunner {
        @Nullable
        public String runRemoteInterface(IBinder var1) throws Throwable;
    }
}

