/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.content.Context;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import androidx.annotation.NonNull;
import com.github.gzuliyujiang.oaid.IGetter;
import com.github.gzuliyujiang.oaid.IOAID;
import com.github.gzuliyujiang.oaid.OAIDLog;
import java.util.Objects;

class MeizuImpl
implements IOAID {
    private final Context context;

    public MeizuImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supported() {
        try {
            ProviderInfo pi = this.context.getPackageManager().resolveContentProvider("com.meizu.flyme.openidsdk", 0);
            return pi != null;
        }
        catch (Throwable e) {
            OAIDLog.print(e);
            return false;
        }
    }

    @Override
    public void doGet(@NonNull IGetter getter) {
        Uri uri = Uri.parse((String)"content://com.meizu.flyme.openidsdk/");
        try (Cursor cursor = this.context.getContentResolver().query(uri, null, null, new String[]{"oaid"}, null);){
            Objects.requireNonNull(cursor).moveToFirst();
            String oaid = cursor.getString(cursor.getColumnIndex("value"));
            OAIDLog.print("OAID query success: " + oaid);
            if (oaid == null || oaid.length() == 0) {
                throw new RuntimeException("OAID query failed");
            }
            getter.onOAIDGetComplete(oaid);
        }
        catch (Throwable e) {
            OAIDLog.print(e);
            getter.onOAIDGetError(e);
        }
    }
}

