/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.IBinder;
import android.provider.Settings;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.github.gzuliyujiang.oaid.IGetter;
import com.github.gzuliyujiang.oaid.IOAID;
import com.github.gzuliyujiang.oaid.OAIDLog;
import com.github.gzuliyujiang.oaid.impl.OAIDService;
import repeackage.com.uodis.opendevice.aidl.OpenDeviceIdentifierService;

class HuaweiImpl
implements IOAID {
    private final Context context;
    private String packageName;

    public HuaweiImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supported() {
        try {
            PackageManager pm = this.context.getPackageManager();
            this.packageName = "com.huawei.hwid";
            if (pm.getPackageInfo(this.packageName, 0) != null) {
                return true;
            }
            this.packageName = "com.huawei.hwid.tv";
            if (pm.getPackageInfo(this.packageName, 0) != null) {
                return true;
            }
            this.packageName = "com.huawei.hms";
            return pm.getPackageInfo(this.packageName, 0) != null;
        }
        catch (Throwable e) {
            OAIDLog.print(e);
            return false;
        }
    }

    @Override
    public void doGet(@NonNull IGetter getter) {
        if (Build.VERSION.SDK_INT >= 24) {
            try {
                String oaid = Settings.Global.getString((ContentResolver)this.context.getContentResolver(), (String)"pps_oaid");
                if (!TextUtils.isEmpty((CharSequence)oaid)) {
                    OAIDLog.print("Get oaid from global settings: " + oaid);
                    getter.onOAIDGetComplete(oaid);
                    return;
                }
            }
            catch (Throwable e) {
                OAIDLog.print(e);
            }
        }
        if (TextUtils.isEmpty((CharSequence)this.packageName) && !this.supported()) {
            getter.onOAIDGetError(new RuntimeException("Huawei Advertising ID not available"));
            return;
        }
        Intent intent = new Intent("com.uodis.opendevice.OPENIDS_SERVICE");
        intent.setPackage(this.packageName);
        OAIDService.bind(this.context, intent, getter, new OAIDService.RemoteRunner(){

            @Override
            public String runRemoteInterface(IBinder service) throws Throwable {
                OpenDeviceIdentifierService anInterface = OpenDeviceIdentifierService.Stub.asInterface(service);
                if (anInterface.isOaidTrackLimited()) {
                    throw new RuntimeException("User has disabled advertising identifier");
                }
                return anInterface.getOaid();
            }
        });
    }
}

