/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.annotation.SuppressLint;
import android.content.Context;
import androidx.annotation.NonNull;
import com.github.gzuliyujiang.oaid.IGetter;
import com.github.gzuliyujiang.oaid.IOAID;
import com.github.gzuliyujiang.oaid.OAIDLog;
import java.lang.reflect.Method;

class XiaomiImpl
implements IOAID {
    private final Context context;
    private Class<?> idProviderClass;
    private Object idProviderImpl;

    @SuppressLint(value={"PrivateApi"})
    public XiaomiImpl(Context context) {
        this.context = context;
        try {
            this.idProviderClass = Class.forName("com.android.id.impl.IdProviderImpl");
            this.idProviderImpl = this.idProviderClass.newInstance();
        }
        catch (Throwable e) {
            OAIDLog.print(e);
        }
    }

    @Override
    public boolean supported() {
        return this.idProviderImpl != null;
    }

    @Override
    public void doGet(@NonNull IGetter getter) {
        if (this.idProviderClass == null || this.idProviderImpl == null) {
            getter.onOAIDGetError(new NullPointerException("Xiaomi IdProvider not exists"));
            return;
        }
        try {
            String oaid = this.getOAID();
            if (oaid == null || oaid.length() <= 0) {
                throw new RuntimeException("Xiaomi OAID get failed");
            }
            getter.onOAIDGetComplete(oaid);
        }
        catch (Throwable e) {
            OAIDLog.print(e);
            getter.onOAIDGetError(e);
        }
    }

    private String getOAID() {
        String result = null;
        try {
            Method method = this.idProviderClass.getMethod("getOAID", Context.class);
            result = (String)method.invoke(this.idProviderImpl, this.context);
        }
        catch (Throwable e) {
            OAIDLog.print(e);
        }
        return result;
    }
}

