/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.IBinder;
import android.provider.Settings;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.github.gzuliyujiang.oaid.IGetter;
import com.github.gzuliyujiang.oaid.IOAID;
import com.github.gzuliyujiang.oaid.OAIDLog;
import repeackage.com.uodis.opendevice.aidl.OpenDeviceIdentifierService;

class HuaweiImpl
implements IOAID {
    private final Context context;
    private String packageName;

    public HuaweiImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supported() {
        try {
            PackageManager pm = this.context.getPackageManager();
            this.packageName = "com.huawei.hwid";
            if (pm.getPackageInfo(this.packageName, 0) != null) {
                return true;
            }
            this.packageName = "com.huawei.hwid.tv";
            if (pm.getPackageInfo(this.packageName, 0) != null) {
                return true;
            }
            this.packageName = "com.huawei.hms";
            return pm.getPackageInfo(this.packageName, 0) != null;
        }
        catch (Throwable e) {
            OAIDLog.print(e);
            return false;
        }
    }

    @Override
    public void doGet(final @NonNull IGetter getter) {
        if (Build.VERSION.SDK_INT >= 24) {
            try {
                String oaid = Settings.Global.getString((ContentResolver)this.context.getContentResolver(), (String)"pps_oaid");
                if (!TextUtils.isEmpty((CharSequence)oaid)) {
                    getter.onOAIDGetComplete(oaid);
                    return;
                }
            }
            catch (Throwable e) {
                OAIDLog.print(e);
            }
        }
        if (TextUtils.isEmpty((CharSequence)this.packageName) && !this.supported()) {
            getter.onOAIDGetError(new RuntimeException("Huawei Advertising ID not available"));
            return;
        }
        Intent intent = new Intent("com.uodis.opendevice.OPENIDS_SERVICE");
        intent.setPackage(this.packageName);
        try {
            boolean isBinded = this.context.bindService(intent, new ServiceConnection(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onServiceConnected(ComponentName name, IBinder service) {
                    OAIDLog.print("Huawei OPENIDS_SERVICE connected");
                    try {
                        OpenDeviceIdentifierService anInterface = OpenDeviceIdentifierService.Stub.asInterface(service);
                        if (anInterface.isOaidTrackLimited()) {
                            getter.onOAIDGetError(new RuntimeException("User has disabled advertising identifier"));
                            return;
                        }
                        String oaid = anInterface.getOaid();
                        if (oaid == null || oaid.length() == 0) {
                            throw new RuntimeException("Huawei Advertising ID get failed");
                        }
                        getter.onOAIDGetComplete(oaid);
                    }
                    catch (Throwable e) {
                        OAIDLog.print(e);
                        getter.onOAIDGetError(e);
                    }
                    finally {
                        try {
                            HuaweiImpl.this.context.unbindService((ServiceConnection)this);
                        }
                        catch (Throwable e) {
                            OAIDLog.print(e);
                        }
                    }
                }

                public void onServiceDisconnected(ComponentName name) {
                    OAIDLog.print("Huawei OPENIDS_SERVICE disconnected");
                }
            }, 1);
            if (!isBinded) {
                throw new RuntimeException("Huawei OPENIDS_SERVICE bind failed");
            }
        }
        catch (Throwable e) {
            getter.onOAIDGetError(e);
        }
    }
}

