/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.os.IBinder;
import androidx.annotation.NonNull;
import com.github.gzuliyujiang.oaid.IGetter;
import com.github.gzuliyujiang.oaid.IOAID;
import com.github.gzuliyujiang.oaid.OAIDLog;
import repeackage.com.google.android.gms.ads.identifier.internal.IAdvertisingIdService;

class GmsImpl
implements IOAID {
    private final Context context;

    public GmsImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supported() {
        try {
            PackageInfo pi = this.context.getPackageManager().getPackageInfo("com.android.vending", 0);
            return pi != null;
        }
        catch (Throwable e) {
            OAIDLog.print(e);
            return false;
        }
    }

    @Override
    public void doGet(final @NonNull IGetter getter) {
        if (!this.supported()) {
            getter.onOAIDGetError(new RuntimeException("Google Play services not available"));
            return;
        }
        Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
        intent.setPackage("com.google.android.gms");
        try {
            boolean isBinded = this.context.bindService(intent, new ServiceConnection(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onServiceConnected(ComponentName name, IBinder service) {
                    OAIDLog.print("Google Play Service connected");
                    try {
                        String id;
                        IAdvertisingIdService anInterface = IAdvertisingIdService.Stub.asInterface(service);
                        if (anInterface.isLimitAdTrackingEnabled(true)) {
                            OAIDLog.print("User has disabled advertising identifier");
                        }
                        if ((id = anInterface.getId()) == null || id.length() == 0) {
                            throw new RuntimeException("Android Advertising ID get failed");
                        }
                        getter.onOAIDGetComplete(id);
                    }
                    catch (Throwable e) {
                        OAIDLog.print(e);
                        getter.onOAIDGetError(e);
                    }
                    finally {
                        try {
                            GmsImpl.this.context.unbindService((ServiceConnection)this);
                        }
                        catch (Throwable e) {
                            OAIDLog.print(e);
                        }
                    }
                }

                public void onServiceDisconnected(ComponentName name) {
                    OAIDLog.print("Google Play Service disconnected");
                }
            }, 1);
            if (!isBinded) {
                throw new RuntimeException("Google Play Service bind failed");
            }
        }
        catch (Throwable e) {
            getter.onOAIDGetError(e);
        }
    }
}

