/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.oaid.impl;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.Signature;
import android.os.IBinder;
import androidx.annotation.NonNull;
import com.github.gzuliyujiang.oaid.IGetter;
import com.github.gzuliyujiang.oaid.IOAID;
import com.github.gzuliyujiang.oaid.OAIDLog;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import repeackage.com.heytap.openid.IOpenID;

class OppoImpl
implements IOAID {
    private final Context context;
    private String sign;

    public OppoImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supported() {
        try {
            PackageInfo pi = this.context.getPackageManager().getPackageInfo("com.heytap.openid", 0);
            return pi != null;
        }
        catch (Throwable e) {
            OAIDLog.print(e);
            return false;
        }
    }

    @Override
    public void doGet(final @NonNull IGetter getter) {
        Intent intent = new Intent("action.com.heytap.openid.OPEN_ID_SERVICE");
        intent.setComponent(new ComponentName("com.heytap.openid", "com.heytap.openid.IdentifyService"));
        try {
            boolean isBinded = this.context.bindService(intent, new ServiceConnection(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onServiceConnected(ComponentName name, IBinder service) {
                    OAIDLog.print("HeyTap IdentifyService connected");
                    try {
                        String ouid = OppoImpl.this.realGetOUID(service);
                        if (ouid == null || ouid.length() == 0) {
                            throw new RuntimeException("HeyTap OUID get failed");
                        }
                        getter.onOAIDGetComplete(ouid);
                    }
                    catch (Throwable e) {
                        OAIDLog.print(e);
                        getter.onOAIDGetError(e);
                    }
                    finally {
                        try {
                            OppoImpl.this.context.unbindService((ServiceConnection)this);
                        }
                        catch (Throwable e) {
                            OAIDLog.print(e);
                        }
                    }
                }

                public void onServiceDisconnected(ComponentName name) {
                    OAIDLog.print("HeyTap IdentifyService disconnected");
                }
            }, 1);
            if (!isBinded) {
                throw new RuntimeException("HeyTap IdentifyService bind failed");
            }
        }
        catch (Throwable e) {
            getter.onOAIDGetError(e);
        }
    }

    @SuppressLint(value={"PackageManagerGetSignatures"})
    private String realGetOUID(IBinder service) throws Exception {
        String pkgName = this.context.getPackageName();
        if (this.sign == null) {
            Signature[] signatures = this.context.getPackageManager().getPackageInfo((String)pkgName, (int)64).signatures;
            byte[] byteArray = signatures[0].toByteArray();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            byte[] digest = messageDigest.digest(byteArray);
            StringBuilder sb = new StringBuilder();
            for (byte b : digest) {
                sb.append(Integer.toHexString(b & 0xFF | 0x100).substring(1, 3));
            }
            this.sign = sb.toString();
            return this.getSerId(service, pkgName, this.sign);
        }
        return this.getSerId(service, pkgName, this.sign);
    }

    private String getSerId(IBinder service, String pkgName, String sign) {
        try {
            Method asInterface = IOpenID.Stub.class.getDeclaredMethod("asInterface", IBinder.class);
            IOpenID anInterface = (IOpenID)asInterface.invoke(null, service);
            if (anInterface == null) {
                throw new NullPointerException("IOpenID is null");
            }
            return anInterface.getSerID(pkgName, sign, "OUID");
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

